/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.io.InputStream;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasWalkingControllerParameters;
import us.ihmc.avatar.DRCFlatGroundWalkingTrack;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simpleWholeBodyWalking.SimpleWalkingControllerStateFactory;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;

public class SimpleAtlasFlatGroundWalkingTrack {
    public static void main(String[] args) {
        AtlasRobotModel model = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.SCS, false){
            private static final String parameterFile = "/us/ihmc/atlas/parameters/experimental_controller_parameters.xml";

            @Override
            public InputStream getWholeBodyControllerParametersFile() {
                return this.getClass().getResourceAsStream(parameterFile);
            }

            @Override
            public InputStream getParameterOverwrites() {
                return null;
            }
        };
        DRCGuiInitialSetup guiInitialSetup = new DRCGuiInitialSetup(true, false);
        double groundHeight = 0.0;
        FlatGroundProfile groundProfile = new FlatGroundProfile(0.0);
        DRCSCSInitialSetup scsInitialSetup = new DRCSCSInitialSetup((GroundProfile3D)groundProfile, model.getSimulateDT());
        scsInitialSetup.setDrawGroundProfile(true);
        scsInitialSetup.setInitializeEstimatorToActual(true);
        double initialYaw = 0.3;
        DRCRobotInitialSetup robotInitialSetup = model.getDefaultRobotInitialSetup(0.0, initialYaw);
        boolean useVelocityAndHeadingScript = true;
        boolean cheatWithGroundHeightAtForFootstep = false;
        HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters = new HeadingAndVelocityEvaluationScriptParameters();
        walkingScriptParameters.setMaxVelocity(0.45);
        walkingScriptParameters.setCruiseVelocity(0.35);
        double currentNominalHeightAboveAnkle = model.getWalkingControllerParameters().nominalHeightAboveAnkle();
        ((AtlasWalkingControllerParameters)model.getWalkingControllerParameters()).setNominalHeightAboveAnkle(currentNominalHeightAboveAnkle + 0.2);
        new DRCFlatGroundWalkingTrack(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, (DRCRobotModel)model, walkingScriptParameters, (HighLevelControllerStateFactory)new SimpleWalkingControllerStateFactory());
    }
}

