/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasSimulationCollisionModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.CollidableVisualizer;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class AtlasSDFViewer {
    private static final boolean SHOW_ELLIPSOIDS = false;
    private static final boolean SHOW_COORDINATES_AT_JOINT_ORIGIN = false;
    private static final boolean SHOW_IMU_FRAMES = false;
    private static final boolean SHOW_KINEMATICS_COLLISIONS = false;
    private static final boolean SHOW_SIM_COLLISIONS = true;

    public static void main(String[] args) {
        AtlasRobotVersion atlasRobotVersion = AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS;
        AtlasRobotModel robotModel = new AtlasRobotModel(atlasRobotVersion, RobotTarget.SCS, false);
        HumanoidFloatingRootJointRobot sdfRobot = robotModel.createHumanoidFloatingRootJointRobot(false);
        FullHumanoidRobotModel fullRobotModel = robotModel.createFullRobotModel();
        fullRobotModel.updateFrames();
        FramePoint3D chestCoM = new FramePoint3D((ReferenceFrame)fullRobotModel.getChest().getBodyFixedFrame());
        chestCoM.changeFrame(ReferenceFrame.getWorldFrame());
        System.out.println(chestCoM);
        AtlasSimulationCollisionModel collisionModel = new AtlasSimulationCollisionModel(robotModel.getJointMap(), atlasRobotVersion);
        collisionModel.setCollidableHelper(new CollidableHelper(), "robot", "ground");
        AtlasSDFViewer.addKinematicsCollisionGraphics(fullRobotModel, (Robot)sdfRobot, collisionModel);
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)sdfRobot);
        SelectedListener selectedListener = new SelectedListener(){

            public void selected(Graphics3DNode graphics3dNode, ModifierKeyInterface modifierKeyInterface, Point3DReadOnly location, Point3DReadOnly cameraLocation, QuaternionReadOnly cameraRotation) {
                System.out.println("Clicked location " + location);
            }
        };
        scs.attachSelectedListener(selectedListener);
        scs.setGroundVisible(false);
        scs.startOnAThread();
    }

    private static void showIMUFrames(HumanoidFloatingRootJointRobot sdfRobot) {
        ArrayList imuMounts = new ArrayList();
        sdfRobot.getIMUMounts(imuMounts);
        for (IMUMount imuMount : imuMounts) {
            Link imuLink = imuMount.getParentJoint().getLink();
            if (imuLink.getLinkGraphics() == null) {
                imuLink.setLinkGraphics(new Graphics3DObject());
            }
            Graphics3DObject linkGraphics = imuLink.getLinkGraphics();
            linkGraphics.identity();
            RigidBodyTransform mountToJoint = new RigidBodyTransform();
            imuMount.getTransformFromMountToJoint(mountToJoint);
            linkGraphics.transform((RigidBodyTransformReadOnly)mountToJoint);
            linkGraphics.addCoordinateSystem(0.3);
            linkGraphics.identity();
        }
    }

    private static void addIntertialEllipsoidsToVisualizer(FloatingRootJointRobot sdfRobot) {
        ArrayList<Joint> joints = new ArrayList<Joint>();
        joints.add((Joint)sdfRobot.getRootJoint());
        HashSet<Link> links = AtlasSDFViewer.getAllLinks(joints, new HashSet<Link>());
        for (Link link : links) {
            if (link.getLinkGraphics() == null) {
                link.setLinkGraphics(new Graphics3DObject());
            }
            AppearanceDefinition appearance = YoAppearance.Green();
            appearance.setTransparency(0.6);
            link.addEllipsoidFromMassProperties(appearance);
            link.addCoordinateSystemToCOM(0.1);
        }
    }

    private static HashSet<Link> getAllLinks(List<Joint> joints, HashSet<Link> links) {
        for (Joint joint : joints) {
            links.add(joint.getLink());
            if (joint.getChildrenJoints().isEmpty()) continue;
            links.addAll(AtlasSDFViewer.getAllLinks(joint.getChildrenJoints(), links));
        }
        return links;
    }

    public static void addJointAxis(FloatingRootJointRobot sdfRobot) {
        ArrayList<OneDegreeOfFreedomJoint> joints = new ArrayList<OneDegreeOfFreedomJoint>(Arrays.asList(sdfRobot.getOneDegreeOfFreedomJoints()));
        for (OneDegreeOfFreedomJoint joint : joints) {
            Graphics3DObject linkGraphics = new Graphics3DObject();
            linkGraphics.addCoordinateSystem(0.3);
            if (joint.getLink().getLinkGraphics() != null) {
                linkGraphics.combine(joint.getLink().getLinkGraphics());
            }
            joint.getLink().setLinkGraphics(linkGraphics);
        }
    }

    public static void addKinematicsCollisionGraphics(FullHumanoidRobotModel fullRobotModel, Robot robot, RobotCollisionModel collisionModel) {
        List robotCollidables = collisionModel.getRobotCollidables(fullRobotModel.getElevator());
        for (Collidable collidable : robotCollidables) {
            Link link = robot.getLink(collidable.getRigidBody().getName());
            Graphics3DObject linkGraphics = link.getLinkGraphics();
            if (linkGraphics == null) {
                linkGraphics = new Graphics3DObject();
                link.setLinkGraphics(linkGraphics);
            }
            linkGraphics.combine(AtlasSDFViewer.getGraphics(collidable));
        }
    }

    private static Graphics3DObject getGraphics(Collidable collidable) {
        FrameShape3DReadOnly shape = collidable.getShape();
        RigidBodyTransform transformToParentJoint = collidable.getShape().getReferenceFrame().getTransformToDesiredFrame((ReferenceFrame)collidable.getRigidBody().getParentJoint().getFrameAfterJoint());
        Graphics3DObject graphics = new Graphics3DObject();
        graphics.transform((RigidBodyTransformReadOnly)transformToParentJoint);
        AppearanceDefinition appearance = YoAppearance.DarkGreen();
        appearance.setTransparency(0.5);
        if (shape instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphere = (Sphere3DReadOnly)shape;
            graphics.translate((Tuple3DReadOnly)sphere.getPosition());
            graphics.addSphere(sphere.getRadius(), appearance);
        } else if (shape instanceof Capsule3DReadOnly) {
            Capsule3DReadOnly capsule = (Capsule3DReadOnly)shape;
            RigidBodyTransform transform = new RigidBodyTransform();
            EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)capsule.getAxis(), (Orientation3DBasics)transform.getRotation());
            transform.getTranslation().set((Tuple3DReadOnly)capsule.getPosition());
            graphics.transform((RigidBodyTransformReadOnly)transform);
            graphics.addCapsule(capsule.getRadius(), capsule.getLength() + 2.0 * capsule.getRadius(), appearance);
        } else if (shape instanceof Box3DReadOnly) {
            Box3DReadOnly box = (Box3DReadOnly)shape;
            graphics.translate((Tuple3DReadOnly)box.getPosition());
            graphics.rotate((Orientation3DReadOnly)new RotationMatrix(box.getOrientation()));
            graphics.addCube(box.getSizeX(), box.getSizeY(), box.getSizeZ(), true, appearance);
        } else if (shape instanceof PointShape3DReadOnly) {
            PointShape3DReadOnly pointShape = (PointShape3DReadOnly)shape;
            graphics.translate((Tuple3DReadOnly)pointShape);
            graphics.addSphere(0.01, appearance);
        } else if (shape instanceof ConvexPolytope3DReadOnly) {
            ConvexPolytope3DReadOnly convexPolytope = (ConvexPolytope3DReadOnly)shape;
            graphics.addMeshData(CollidableVisualizer.newConvexPolytope3DMesh((ConvexPolytope3DReadOnly)convexPolytope), appearance);
        } else {
            throw new UnsupportedOperationException("Unsupported shape: " + shape.getClass().getSimpleName());
        }
        return graphics;
    }
}

