/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.io.InputStream;
import java.util.List;
import us.ihmc.atlas.AtlasDampingParameters;
import us.ihmc.atlas.AtlasDirectRobotInterface;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.AtlasRobotModelShapeCollisionSettings;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.diagnostic.AtlasDiagnosticParameters;
import us.ihmc.atlas.initialSetup.AtlasSimInitialSetup;
import us.ihmc.atlas.parameters.AtlasCoPTrajectoryParameters;
import us.ihmc.atlas.parameters.AtlasCollisionMeshDefinitionDataHolder;
import us.ihmc.atlas.parameters.AtlasContactPointParameters;
import us.ihmc.atlas.parameters.AtlasFootstepPlannerParameters;
import us.ihmc.atlas.parameters.AtlasHighLevelControllerParameters;
import us.ihmc.atlas.parameters.AtlasICPSplitFractionCalculatorParameters;
import us.ihmc.atlas.parameters.AtlasKinematicsCollisionModel;
import us.ihmc.atlas.parameters.AtlasPhysicalProperties;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.atlas.parameters.AtlasSimulationCollisionModel;
import us.ihmc.atlas.parameters.AtlasStateEstimatorParameters;
import us.ihmc.atlas.parameters.AtlasSwingPlannerParameters;
import us.ihmc.atlas.parameters.AtlasUIParameters;
import us.ihmc.atlas.parameters.AtlasVisibilityGraphParameters;
import us.ihmc.atlas.parameters.AtlasWalkingControllerParameters;
import us.ihmc.atlas.ros.AtlasPPSTimestampOffsetProvider;
import us.ihmc.atlas.sensors.AtlasCollisionBoxProvider;
import us.ihmc.atlas.sensors.AtlasSensorSuiteManager;
import us.ihmc.avatar.DRCSimulationOutputWriterForControllerThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.drcRobot.shapeContactSettings.DRCRobotModelShapeCollisionSettings;
import us.ihmc.avatar.factory.SimulatedHandControlTask;
import us.ihmc.avatar.handControl.packetsAndConsumers.HandModel;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.avatar.networkProcessor.time.DRCROSAlwaysZeroOffsetPPSTimestampOffsetProvider;
import us.ihmc.avatar.reachabilityMap.footstep.StepReachabilityFileTools;
import us.ihmc.avatar.ros.DRCROSPPSTimestampOffsetProvider;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RobotROSClockCalculatorFromPPSOffset;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.staticReachability.StepReachabilityData;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.footstepPlanning.graphSearch.parameters.FootstepPlannerParametersBasics;
import us.ihmc.footstepPlanning.swing.SwingPlannerParametersBasics;
import us.ihmc.ihmcPerception.depthData.CollisionBoxProvider;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.DRCRobotSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.JaxbSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.RobotDescriptionFromSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.SDFContactSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFDescriptionMutator;
import us.ihmc.modelFileLoaders.SdfLoader.SDFForceSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFModelLoader;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFGeometry;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFSensor;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFVisual;
import us.ihmc.multicastLogDataProtocol.modelLoaders.DefaultLogModelProvider;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullHumanoidRobotModelFromDescription;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.ContactPointDefinitionHolder;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotDescription.collisionMeshDefinitionData.CollisionMeshDefinitionDataHolder;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotiq.model.RobotiqHandModel;
import us.ihmc.robotiq.simulatedHand.SimulatedRobotiqHandsController;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.wholeBodyController.DRCOutputProcessor;
import us.ihmc.wholeBodyController.FootContactPoints;
import us.ihmc.wholeBodyController.UIParameters;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticParameters;

public class AtlasRobotModel
implements DRCRobotModel,
SDFDescriptionMutator {
    public static final boolean SCALE_ATLAS = false;
    private static final double DESIRED_ATLAS_HEIGHT = 0.66;
    private static final double DESIRED_ATLAS_WEIGHT = 15.0;
    private final double HARDSTOP_RESTRICTION_ANGLE = Math.toRadians(5.0);
    private final AtlasRobotVersion selectedVersion;
    private final RobotTarget target;
    private static final long ESTIMATOR_DT_IN_NS = 1000000L;
    private static final double ESTIMATOR_DT = Conversions.nanosecondsToSeconds((long)1000000L);
    private static final double CONTROL_DT = 0.004;
    private static final double ATLAS_ONBOARD_SAMPLINGFREQ = 1000.0;
    public static final double ATLAS_ONBOARD_DT = 0.001;
    public static final boolean BATTERY_MASS_SIMULATOR_IN_ROBOT = false;
    private final JaxbSDFLoader loader;
    private final AtlasPhysicalProperties atlasPhysicalProperties = new AtlasPhysicalProperties();
    private final AtlasJointMap jointMap;
    private final AtlasContactPointParameters contactPointParameters;
    private final AtlasSensorInformation sensorInformation;
    private final AtlasWalkingControllerParameters walkingControllerParameters;
    private final AtlasStateEstimatorParameters stateEstimatorParameters;
    private final AtlasHighLevelControllerParameters highLevelControllerParameters;
    private final AtlasCollisionMeshDefinitionDataHolder collisionMeshDefinitionDataHolder;
    private AtlasSensorSuiteManager sensorSuiteManager;
    private boolean useShapeCollision = false;
    private final RobotDescription robotDescription;

    public AtlasRobotModel(AtlasRobotVersion atlasVersion) {
        this(atlasVersion, RobotTarget.SCS);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target) {
        this(atlasVersion, target, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless) {
        this(atlasVersion, target, headless, null, false, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, boolean createAdditionalContactPoints) {
        this(atlasVersion, target, headless, null, createAdditionalContactPoints, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, boolean createAdditionalContactPoints, boolean useShapeCollision) {
        this(atlasVersion, target, headless, null, createAdditionalContactPoints, useShapeCollision);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, FootContactPoints<RobotSide> simulationContactPoints) {
        this(atlasVersion, target, headless, simulationContactPoints, false, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, FootContactPoints<RobotSide> simulationContactPoints, boolean createAdditionalContactPointsn) {
        this(atlasVersion, target, headless, simulationContactPoints, createAdditionalContactPointsn, false);
    }

    public AtlasRobotModel(AtlasRobotVersion atlasVersion, RobotTarget target, boolean headless, FootContactPoints<RobotSide> simulationContactPoints, boolean createAdditionalContactPoints, boolean useShapeCollision) {
        this.selectedVersion = atlasVersion;
        this.jointMap = new AtlasJointMap(this.selectedVersion, this.atlasPhysicalProperties);
        boolean createFootContactPoints = true;
        this.contactPointParameters = new AtlasContactPointParameters(this.jointMap, atlasVersion, createFootContactPoints, simulationContactPoints, createAdditionalContactPoints);
        this.target = target;
        InputStream stream = this.selectedVersion.getSdfFileAsStream();
        if (stream == null) {
            LogTools.error((String)"Selected version {} could not be found: stream is null", (Object)((Object)this.selectedVersion));
        }
        this.loader = DRCRobotSDFLoader.loadDRCRobot((String[])this.selectedVersion.getResourceDirectories(), (InputStream)stream, (SDFDescriptionMutator)this);
        this.sensorInformation = new AtlasSensorInformation(atlasVersion, target);
        for (String forceSensorNames : this.sensorInformation.getForceSensorNames()) {
            this.loader.addForceSensor((JointNameMap)this.jointMap, forceSensorNames, forceSensorNames, new RigidBodyTransform());
        }
        boolean runningOnRealRobot = target == RobotTarget.REAL_ROBOT;
        this.highLevelControllerParameters = new AtlasHighLevelControllerParameters(runningOnRealRobot, this.jointMap);
        this.walkingControllerParameters = new AtlasWalkingControllerParameters(target, this.jointMap, this.contactPointParameters);
        this.stateEstimatorParameters = new AtlasStateEstimatorParameters(this.jointMap, this.sensorInformation, runningOnRealRobot, this.getEstimatorDT());
        this.collisionMeshDefinitionDataHolder = new AtlasCollisionMeshDefinitionDataHolder(this.jointMap, this.atlasPhysicalProperties);
        this.useShapeCollision = useShapeCollision;
        this.robotDescription = this.createRobotDescription();
    }

    private RobotDescription createRobotDescription() {
        RobotDescription robotDescription;
        boolean useCollisionMeshes = false;
        GeneralizedSDFRobotModel generalizedSDFRobotModel = this.getGeneralizedRobotModel();
        RobotDescriptionFromSDFLoader descriptionLoader = new RobotDescriptionFromSDFLoader();
        if (this.useShapeCollision) {
            robotDescription = descriptionLoader.loadRobotDescriptionFromSDF(generalizedSDFRobotModel, (JointNameMap)this.jointMap, this.useShapeCollision);
            this.collisionMeshDefinitionDataHolder.setVisible(false);
            robotDescription.addCollisionMeshDefinitionData((CollisionMeshDefinitionDataHolder)this.collisionMeshDefinitionDataHolder);
        } else {
            robotDescription = descriptionLoader.loadRobotDescriptionFromSDF(generalizedSDFRobotModel, (JointNameMap)this.jointMap, (ContactPointDefinitionHolder)this.contactPointParameters, useCollisionMeshes);
        }
        return robotDescription;
    }

    public DRCRobotModelShapeCollisionSettings getShapeCollisionSettings() {
        return new AtlasRobotModelShapeCollisionSettings(this.useShapeCollision);
    }

    public RobotDescription getRobotDescription() {
        return this.robotDescription;
    }

    public HighLevelControllerParameters getHighLevelControllerParameters() {
        return this.highLevelControllerParameters;
    }

    public WalkingControllerParameters getWalkingControllerParameters() {
        return this.walkingControllerParameters;
    }

    public CoPTrajectoryParameters getCoPTrajectoryParameters() {
        return new AtlasCoPTrajectoryParameters();
    }

    public SplitFractionCalculatorParametersReadOnly getSplitFractionCalculatorParameters() {
        return new AtlasICPSplitFractionCalculatorParameters();
    }

    public StateEstimatorParameters getStateEstimatorParameters() {
        return this.stateEstimatorParameters;
    }

    public AtlasPhysicalProperties getPhysicalProperties() {
        return this.atlasPhysicalProperties;
    }

    public RobotTarget getTarget() {
        return this.target;
    }

    public AtlasJointMap getJointMap() {
        return this.jointMap;
    }

    public AtlasRobotVersion getAtlasVersion() {
        return this.selectedVersion;
    }

    public String toString() {
        return this.selectedVersion.toString();
    }

    public DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> getDefaultRobotInitialSetup(double groundHeight, double initialYaw) {
        return new AtlasSimInitialSetup(groundHeight, initialYaw);
    }

    public DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> getDefaultRobotInitialSetup(double groundHeight, double initialYaw, double initialX, double initialY) {
        return new AtlasSimInitialSetup(groundHeight, initialYaw, initialX, initialY);
    }

    public AtlasContactPointParameters getContactPointParameters() {
        return this.contactPointParameters;
    }

    public void setJointDamping(FloatingRootJointRobot simulatedRobot) {
        AtlasDampingParameters.setDampingParameters(simulatedRobot, this.getJointMap());
    }

    public HandModel getHandModel() {
        if (this.selectedVersion.hasRobotiqHands()) {
            return new RobotiqHandModel();
        }
        return null;
    }

    public HumanoidRobotSensorInformation getSensorInformation() {
        return this.sensorInformation;
    }

    public FullHumanoidRobotModel createFullRobotModel() {
        RobotDescription robotDescription = this.loader.createRobotDescription((JointNameMap)this.getJointMap(), (ContactPointDefinitionHolder)this.getContactPointParameters());
        FullHumanoidRobotModelFromDescription fullRobotModel = new FullHumanoidRobotModelFromDescription(robotDescription, (HumanoidJointNameMap)this.getJointMap(), this.sensorInformation.getSensorFramesToTrack());
        for (RobotSide robotSide : RobotSide.values()) {
            ArmJointName[] armJointNames;
            for (ArmJointName armJointName : armJointNames = new ArmJointName[]{ArmJointName.FIRST_WRIST_PITCH, ArmJointName.WRIST_ROLL, ArmJointName.SECOND_WRIST_PITCH}) {
                OneDoFJointBasics armJoint = fullRobotModel.getArmJoint(robotSide, armJointName);
                if (armJoint == null) continue;
                double lowerLimit = armJoint.getJointLimitLower();
                double upperLimit = armJoint.getJointLimitUpper();
                double range = upperLimit - lowerLimit;
                if (range > 2.0 * this.HARDSTOP_RESTRICTION_ANGLE) {
                    double safeLowerBound = lowerLimit + this.HARDSTOP_RESTRICTION_ANGLE;
                    double safeUpperBound = upperLimit - this.HARDSTOP_RESTRICTION_ANGLE;
                    armJoint.setJointLimitLower(safeLowerBound);
                    armJoint.setJointLimitUpper(safeUpperBound);
                    continue;
                }
                System.out.println(this.getClass().getName() + ", createFullRobotModel(): range not large enough to reduce for side=" + robotSide.getLowerCaseName() + " joint=" + armJointName.getCamelCaseNameForStartOfExpression());
            }
        }
        return fullRobotModel;
    }

    public HumanoidFloatingRootJointRobot createHumanoidFloatingRootJointRobot(boolean createCollisionMeshes, boolean enableJointDamping) {
        boolean enableTorqueVelocityLimits = false;
        HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot = new HumanoidFloatingRootJointRobot(this.robotDescription, (HumanoidJointNameMap)this.jointMap, enableJointDamping, enableTorqueVelocityLimits);
        return humanoidFloatingRootJointRobot;
    }

    public double getSimulateDT() {
        return 5.0E-4;
    }

    public double getEstimatorDT() {
        return ESTIMATOR_DT;
    }

    public double getControllerDT() {
        return 0.004;
    }

    private GeneralizedSDFRobotModel getGeneralizedRobotModel() {
        return this.loader.getGeneralizedSDFRobotModel(this.getJointMap().getModelName());
    }

    public RobotROSClockCalculator getROSClockCalculator() {
        DRCROSPPSTimestampOffsetProvider timestampOffsetProvider = null;
        if (this.target == RobotTarget.REAL_ROBOT) {
            timestampOffsetProvider = AtlasPPSTimestampOffsetProvider.getInstance(this.sensorInformation);
        }
        if (timestampOffsetProvider == null) {
            timestampOffsetProvider = new DRCROSAlwaysZeroOffsetPPSTimestampOffsetProvider();
        }
        return new RobotROSClockCalculatorFromPPSOffset(timestampOffsetProvider);
    }

    public String getStepReachabilityResourceName() {
        return "ihmc-open-robotics-software/atlas/src/main/resources/us/ihmc/atlas/parameters/StepReachabilityMap.csv";
    }

    public StepReachabilityData getStepReachabilityData() {
        return StepReachabilityFileTools.loadFromFile((String)this.getStepReachabilityResourceName());
    }

    public AtlasSensorSuiteManager getSensorSuiteManager() {
        return this.getSensorSuiteManager(null);
    }

    public AtlasSensorSuiteManager getSensorSuiteManager(ROS2NodeInterface ros2Node) {
        if (this.sensorSuiteManager == null) {
            this.sensorSuiteManager = new AtlasSensorSuiteManager(this.getSimpleRobotName(), (FullHumanoidRobotModelFactory)this, this.getCollisionBoxProvider(), this.getROSClockCalculator(), this.sensorInformation, this.getJointMap(), this.getPhysicalProperties(), this.target, ros2Node);
        }
        return this.sensorSuiteManager;
    }

    public UIParameters getUIParameters() {
        return new AtlasUIParameters(this.selectedVersion, this.atlasPhysicalProperties);
    }

    public SimulatedHandControlTask createSimulatedHandController(FloatingRootJointRobot simulatedRobot, RealtimeROS2Node realtimeROS2Node) {
        switch (this.selectedVersion.getHandModel()) {
            case ROBOTIQ: {
                return new SimulatedRobotiqHandsController(simulatedRobot, (DRCRobotModel)this, realtimeROS2Node, ROS2Tools.getControllerOutputTopic((String)this.getSimpleRobotName()), ROS2Tools.getControllerInputTopic((String)this.getSimpleRobotName()));
            }
        }
        return null;
    }

    public LogModelProvider getLogModelProvider() {
        return new DefaultLogModelProvider(SDFModelLoader.class, this.jointMap.getModelName(), this.selectedVersion.getSdfFileAsStream(), this.selectedVersion.getResourceDirectories());
    }

    public DataServerSettings getLogSettings() {
        switch (this.target) {
            case REAL_ROBOT: {
                return new DataServerSettings(true, "AtlasGUI");
            }
        }
        return new DataServerSettings(false, "SimulationGUI");
    }

    public String getSimpleRobotName() {
        return "Atlas";
    }

    public CollisionBoxProvider getCollisionBoxProvider() {
        return new AtlasCollisionBoxProvider(this.loader, this.getJointMap());
    }

    public void mutateJointForModel(GeneralizedSDFRobotModel model, SDFJointHolder jointHolder) {
        if (this.jointMap.getModelName().equals(model.getName())) {
            // empty if block
        }
    }

    public void mutateLinkForModel(GeneralizedSDFRobotModel model, SDFLinkHolder linkHolder) {
        if (this.jointMap.getModelName().equals(model.getName())) {
            List visuals = linkHolder.getVisuals();
            if (visuals != null) {
                for (SDFVisual sdfVisual : visuals) {
                    String meshUri;
                    SDFGeometry.Mesh mesh;
                    SDFGeometry geometry = sdfVisual.getGeometry();
                    if (geometry == null || (mesh = geometry.getMesh()) == null || !(meshUri = mesh.getUri()).contains("meshes_unplugged")) continue;
                    String replacedURI = meshUri.replace(".dae", ".obj");
                    mesh.setUri(replacedURI);
                }
            }
            switch (linkHolder.getName()) {
                case "pelvis": {
                    break;
                }
                case "utorso": {
                    this.addCustomCrashProtectionVisual(linkHolder);
                    this.modifyLinkInertialPose(linkHolder, "0.017261 0.0032352 0.3483 0 0 0");
                    this.modifyLinkMass(linkHolder, 60.009);
                    double ixx = 1.5;
                    double ixy = 0.0;
                    double ixz = 0.1;
                    double iyy = 1.5;
                    double iyz = 0.0;
                    double izz = 0.5;
                    this.modifyLinkInertia(linkHolder, new Matrix3D(ixx, ixy, ixz, ixy, iyy, iyz, ixz, iyz, izz));
                    this.addChestIMU(linkHolder);
                    break;
                }
                case "l_lfarm": 
                case "r_lfarm": {
                    this.modifyLinkMass(linkHolder, 1.6);
                    break;
                }
                case "l_hand": {
                    this.modifyLeftHand(linkHolder);
                    break;
                }
                case "r_hand": {
                    this.modifyRightHand(linkHolder);
                    break;
                }
                case "l_finger_1_link_0": {
                    this.modifyLinkPose(linkHolder, "0.0903097 1.15155 0.38309 1.5708 0.000796327 1.5708");
                    break;
                }
                case "l_finger_1_link_1": {
                    this.modifyLinkPose(linkHolder, "0.0903097 1.15155 0.38309 1.5708 0.000796327 1.5708");
                    break;
                }
                case "l_finger_1_link_2": {
                    this.modifyLinkPose(linkHolder, "0.0903092 1.20153 0.35505 1.5708 0.520796 1.57081");
                    break;
                }
                case "l_finger_1_link_3": {
                    this.modifyLinkPose(linkHolder, "0.0903088 1.23536 0.335645 1.5708 0.000796327 1.5708");
                    break;
                }
                case "l_finger_2_link_0": {
                    this.modifyLinkPose(linkHolder, "0.16231 1.15155 0.38309 1.5708 0.000796327 1.5708");
                    break;
                }
                case "l_finger_2_link_1": {
                    this.modifyLinkPose(linkHolder, "0.16231 1.15155 0.38309 1.5708 0.000796327 1.5708");
                    break;
                }
                case "l_finger_2_link_2": {
                    this.modifyLinkPose(linkHolder, "0.162309 1.20153 0.35505 1.5708 0.520796 1.57081");
                    break;
                }
                case "l_finger_2_link_3": {
                    this.modifyLinkPose(linkHolder, "0.162309 1.23536 0.335645 1.5708 0.000796327 1.5708");
                    break;
                }
                case "l_finger_middle_link_0": {
                    this.modifyLinkPose(linkHolder, "0.12631 1.15155 0.47409 -1.57079 -0.000796327 1.5708");
                    break;
                }
                case "l_finger_middle_link_1": {
                    this.modifyLinkPose(linkHolder, "0.12631 1.15155 0.47409 -1.57079 -0.000796327 1.5708");
                    break;
                }
                case "l_finger_middle_link_2": {
                    this.modifyLinkPose(linkHolder, "0.12631 1.20153 0.50213 -1.57079 -0.520796 1.57079");
                    break;
                }
                case "l_finger_middle_link_3": {
                    this.modifyLinkPose(linkHolder, "0.126311 1.23536 0.521535 -1.57079 -0.000796327 1.5708");
                    break;
                }
                case "r_finger_1_link_0": {
                    this.modifyLinkPose(linkHolder, "0.16231 -1.15155 0.38309 1.57079 0.000796327 -1.57079");
                    break;
                }
                case "r_finger_1_link_1": {
                    this.modifyLinkPose(linkHolder, "0.16231 -1.15155 0.38309 1.57079 0.000796327 -1.57079");
                    break;
                }
                case "r_finger_1_link_2": {
                    this.modifyLinkPose(linkHolder, "0.16231 -1.20153 0.35505 1.57079 0.520796 -1.57079");
                    break;
                }
                case "r_finger_1_link_3": {
                    this.modifyLinkPose(linkHolder, "0.16231 -1.23536 0.335645 1.57079 0.000796327 -1.57079");
                    break;
                }
                case "r_finger_2_link_0": {
                    this.modifyLinkPose(linkHolder, "0.0903097 -1.15155 0.38309 1.57079 0.000796327 -1.57079");
                    break;
                }
                case "r_finger_2_link_1": {
                    this.modifyLinkPose(linkHolder, "0.0903097 -1.15155 0.38309 1.57079 0.000796327 -1.57079");
                    break;
                }
                case "r_finger_2_link_2": {
                    this.modifyLinkPose(linkHolder, "0.0903099 -1.20153 0.35505 1.57079 0.520796 -1.57079");
                    break;
                }
                case "r_finger_2_link_3": {
                    this.modifyLinkPose(linkHolder, "0.09031 -1.23536 0.335645 1.57079 0.000796327 -1.57079");
                    break;
                }
                case "r_finger_middle_link_0": {
                    this.modifyLinkPose(linkHolder, "0.12631 -1.15155 0.47409 -1.5708 -0.000796327 -1.5708");
                    break;
                }
                case "r_finger_middle_link_1": {
                    this.modifyLinkPose(linkHolder, "0.12631 -1.15155 0.47409 -1.5708 -0.000796327 -1.5708");
                    break;
                }
                case "r_finger_middle_link_2": {
                    this.modifyLinkPose(linkHolder, "0.12631 -1.20153 0.50213 -1.5708 -0.520796 -1.57079");
                    break;
                }
                case "r_finger_middle_link_3": {
                    this.modifyLinkPose(linkHolder, "0.126311 -1.23536 0.521535 -1.5708 -0.000796327 -1.5708");
                    break;
                }
                case "hokuyo_link": {
                    this.modifyHokuyoInertia(linkHolder);
                }
            }
        }
    }

    public void mutateSensorForModel(GeneralizedSDFRobotModel model, SDFSensor sensor) {
        if (this.jointMap.getModelName().equals(model.getName())) {
            if (sensor.getType().equals("imu") && sensor.getName().equals("imu_sensor")) {
                sensor.setName("imu_sensor_at_pelvis_frame");
            }
            if (sensor.getType().equals("gpu_ray") && sensor.getName().equals("head_hokuyo_sensor")) {
                sensor.getRay().getScan().getHorizontal().setSamples("720");
                sensor.getRay().getScan().getHorizontal().setMinAngle("-1.5708");
                sensor.getRay().getScan().getHorizontal().setMaxAngle("1.5708");
            }
        }
    }

    public void mutateForceSensorForModel(GeneralizedSDFRobotModel model, SDFForceSensor forceSensor) {
        if (this.jointMap.getModelName().equals(model.getName())) {
            // empty if block
        }
    }

    public void mutateContactSensorForModel(GeneralizedSDFRobotModel model, SDFContactSensor contactSensor) {
        if (this.jointMap.getModelName().equals(model.getName())) {
            // empty if block
        }
    }

    public void mutateModelWithAdditions(GeneralizedSDFRobotModel model) {
        if (this.jointMap.getModelName().equals(model.getName())) {
            // empty if block
        }
    }

    private void addChestIMU(SDFLinkHolder chestLink) {
        SDFSensor chestIMU = new SDFSensor();
        chestIMU.setName("imu_sensor_chest");
        chestIMU.setType("imu");
        String piHalf = String.valueOf(1.5707963267948966);
        String negativePiHalf = String.valueOf(-1.5707963267948966);
        chestIMU.setPose("-0.15 0.0 0.3 " + piHalf + " 0.0 " + negativePiHalf);
        SDFSensor.IMU imu = new SDFSensor.IMU();
        chestIMU.setImu(imu);
        chestLink.getSensors().add(chestIMU);
    }

    private void modifyHokuyoInertia(SDFLinkHolder linkHolder) {
        linkHolder.getInertia().setM00(4.01606E-4);
        linkHolder.getInertia().setM01(4.9927E-8);
        linkHolder.getInertia().setM02(1.0997E-5);
        linkHolder.getInertia().setM11(0.00208115);
        linkHolder.getInertia().setM12(-9.8165E-9);
        linkHolder.getInertia().setM22(0.00178402);
    }

    private void addCustomCrashProtectionVisual(SDFLinkHolder linkHolder) {
        List visuals = linkHolder.getVisuals();
        SDFVisual crashProtectionVisual = new SDFVisual();
        crashProtectionVisual.setName("utorso_crash_visual");
        SDFVisual.SDFMaterial crashProtectionVisualMaterial = new SDFVisual.SDFMaterial();
        crashProtectionVisualMaterial.setLighting("1");
        crashProtectionVisualMaterial.setAmbient("0.75686275 0 0.75686275 1");
        crashProtectionVisualMaterial.setDiffuse(".7 0 .7 1");
        crashProtectionVisualMaterial.setSpecular("1 0 1 1");
        crashProtectionVisualMaterial.setEmissive("0 0 1 1");
        SDFGeometry crashProtectionGeometry = new SDFGeometry();
        SDFGeometry.Mesh crashProtectionGeometryMesh = new SDFGeometry.Mesh();
        crashProtectionGeometryMesh.setScale("1 1 1");
        crashProtectionGeometryMesh.setUri("model://atlas_description/meshes_unplugged/ATLAS_UNPLUGGED_UPPER_BODY_CRASH_PROTECTION_NO_SHOULDER.stl");
        crashProtectionGeometry.setMesh(crashProtectionGeometryMesh);
        crashProtectionVisual.setMaterial(crashProtectionVisualMaterial);
        crashProtectionVisual.setPose("0 0 0 0 -0 0");
        crashProtectionVisual.setGeometry(crashProtectionGeometry);
        visuals.add(crashProtectionVisual);
    }

    private void modifyLeftHand(SDFLinkHolder linkHolder) {
        this.modifyLinkMass(linkHolder, 2.7);
        this.modifyLinkInertialPose(linkHolder, "-0.0 0.04 0.0 0 -0 0");
        List visuals = linkHolder.getVisuals();
        if (visuals != null) {
            for (SDFVisual sdfVisual : visuals) {
                if (!sdfVisual.getName().equals("l_hand_visual")) continue;
                sdfVisual.setPose("-0.00179 0.126 0 0 -1.57079 0");
            }
        }
    }

    private void modifyRightHand(SDFLinkHolder linkHolder) {
        this.modifyLinkMass(linkHolder, 2.7);
        this.modifyLinkInertialPose(linkHolder, "-0.0 -0.04 0.0 0 -0 0");
        List visuals = linkHolder.getVisuals();
        if (visuals != null) {
            for (SDFVisual sdfVisual : visuals) {
                if (!sdfVisual.getName().equals("r_hand_visual")) continue;
                sdfVisual.setPose("-0.00179 -0.126 0 3.14159 -1.57079 0");
                sdfVisual.getGeometry().getMesh().setUri("model://robotiq_hand_description/meshes/s-model_articulated/visual/palmRight.STL");
            }
            this.addCheckerboardToRightHand(visuals);
        }
    }

    private void addCheckerboardToRightHand(List<SDFVisual> visuals) {
        SDFVisual chessboardVisual = new SDFVisual();
        chessboardVisual.setName("r_hand_chessboard");
        chessboardVisual.setPose("0.065 -0.198 0.04 0 1.57 0");
        SDFGeometry chessboardVisualGeometry = new SDFGeometry();
        SDFGeometry.Mesh chessboardVisualGeometryMesh = new SDFGeometry.Mesh();
        chessboardVisualGeometryMesh.setScale(".75 .75 .01");
        chessboardVisualGeometryMesh.setUri("model://ihmc/calibration_cube.dae");
        chessboardVisualGeometry.setMesh(chessboardVisualGeometryMesh);
        chessboardVisual.setGeometry(chessboardVisualGeometry);
        visuals.add(chessboardVisual);
    }

    private void modifyLinkMass(SDFLinkHolder linkHolder, double mass) {
        linkHolder.setMass(mass);
    }

    private void modifyLinkPose(SDFLinkHolder linkHolder, String pose) {
        linkHolder.getTransformFromModelReferenceFrame().set(ModelFileLoaderConversionsHelper.poseToTransform((String)pose));
    }

    private void modifyLinkInertialPose(SDFLinkHolder linkHolder, String pose) {
        linkHolder.setInertialFrameWithRespectToLinkFrame(ModelFileLoaderConversionsHelper.poseToTransform((String)pose));
    }

    private void modifyLinkInertia(SDFLinkHolder linkHolder, Matrix3D inertia) {
        linkHolder.setInertia(inertia);
    }

    public FootstepPlannerParametersBasics getFootstepPlannerParameters() {
        return new AtlasFootstepPlannerParameters();
    }

    public FootstepPlannerParametersBasics getFootstepPlannerParameters(String fileNameSuffix) {
        return new AtlasFootstepPlannerParameters(fileNameSuffix);
    }

    public VisibilityGraphsParametersBasics getVisibilityGraphsParameters() {
        return new AtlasVisibilityGraphParameters();
    }

    public SwingPlannerParametersBasics getSwingPlannerParameters() {
        return new AtlasSwingPlannerParameters();
    }

    public SwingPlannerParametersBasics getSwingPlannerParameters(String fileNameSuffix) {
        return new AtlasSwingPlannerParameters(fileNameSuffix);
    }

    public DRCOutputProcessor getCustomSimulationOutputProcessor(HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot) {
        return new DRCSimulationOutputWriterForControllerThread((FloatingRootJointRobot)humanoidFloatingRootJointRobot);
    }

    public JointDesiredOutputWriter getCustomSimulationOutputWriter(HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot, HumanoidRobotContextData contextData) {
        return null;
    }

    public static String getParameterResourceName() {
        return "/us/ihmc/atlas/parameters/controller.xml";
    }

    public String getParameterFileName() {
        return AtlasRobotModel.getParameterResourceName();
    }

    public InputStream getParameterOverwrites() {
        if (this.target == RobotTarget.REAL_ROBOT) {
            return this.getClass().getResourceAsStream("/us/ihmc/atlas/parameters/real_robot.xml");
        }
        return null;
    }

    public InputStream getWholeBodyControllerParametersFile() {
        return this.getClass().getResourceAsStream(AtlasRobotModel.getParameterResourceName());
    }

    public RobotCollisionModel getHumanoidRobotKinematicsCollisionModel() {
        return new AtlasKinematicsCollisionModel(this.jointMap);
    }

    public RobotCollisionModel getSimulationRobotCollisionModel(CollidableHelper helper, String robotCollisionMask, String ... environmentCollisionMasks) {
        AtlasSimulationCollisionModel collisionModel = new AtlasSimulationCollisionModel(this.jointMap, this.selectedVersion);
        collisionModel.setCollidableHelper(helper, robotCollisionMask, environmentCollisionMasks);
        return collisionModel;
    }

    public DiagnosticParameters getDiagnoticParameters() {
        return new AtlasDiagnosticParameters(this.getJointMap(), this.getSensorInformation(), this.target == RobotTarget.REAL_ROBOT);
    }

    public RobotLowLevelMessenger newRobotLowLevelMessenger(ROS2NodeInterface ros2Node) {
        return new AtlasDirectRobotInterface(ros2Node, this);
    }
}

