/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import controller_msgs.msg.dds.ToolboxStateMessage;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.environments.PhaseOneDemoEnvironment;
import us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox.FiducialDetectorToolboxModule;
import us.ihmc.avatar.networkProcessor.objectDetectorToolBox.ObjectDetectorToolboxModule;
import us.ihmc.avatar.simulationStarter.DRCSimulationStarter;
import us.ihmc.avatar.simulationStarter.DRCSimulationTools;
import us.ihmc.avatar.simulationStarter.SimulationStarterInterface;
import us.ihmc.behaviors.BehaviorDefinition;
import us.ihmc.behaviors.BehaviorModule;
import us.ihmc.behaviors.BehaviorRegistry;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUI;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIDefinition;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIRegistry;
import us.ihmc.behaviors.javafx.behaviors.LookAndStepBehaviorUI;
import us.ihmc.behaviors.stairs.TraverseStairsBehavior;
import us.ihmc.behaviors.tools.PlanarRegionSLAMMapper;
import us.ihmc.behaviors.tools.perception.MultisenseHeadStereoSimulator;
import us.ihmc.behaviors.tools.perception.PeriodicPlanarRegionPublisher;
import us.ihmc.behaviors.tools.perception.RealsensePelvisSimulator;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasPhaseOneDemo {
    private static boolean START_LOOK_AND_STEP_UI = Boolean.parseBoolean(System.getProperty("start.look.and.step.ui"));
    private static int STARTING_LOCATION = Integer.parseInt(System.getProperty("starting.location", "1"));
    private static boolean CREATE_PUSH_DOOR = Boolean.parseBoolean(System.getProperty("create.push.door", "true"));
    private static boolean CREATE_PULL_DOOR = Boolean.parseBoolean(System.getProperty("create.pull.door", "true"));
    private static boolean CREATE_DEBRIS = Boolean.parseBoolean(System.getProperty("create.debris", "true"));
    private static boolean CREATE_BARREL = Boolean.parseBoolean(System.getProperty("create.barrel", "false"));
    private static boolean CREATE_STAIRS = Boolean.parseBoolean(System.getProperty("create.stairs", "true"));
    private static boolean CREATE_CINDER_BLOCK_FIELD = Boolean.parseBoolean(System.getProperty("create.cinder.block.field", "true"));
    private final AtomicBoolean ignoreDebris = new AtomicBoolean(false);
    private final PhaseOneDemoEnvironment environment;
    private boolean lastIgnoreDebrisValueUsedByRealsense = true;

    public AtlasPhaseOneDemo() {
        PhaseOneDemoEnvironment.StartingLocation startingLocation = PhaseOneDemoEnvironment.StartingLocation.values()[STARTING_LOCATION];
        AtlasRobotModel robotModel = this.createRobotModel();
        this.environment = new PhaseOneDemoEnvironment(CREATE_PUSH_DOOR, CREATE_PULL_DOOR, CREATE_DEBRIS, CREATE_BARREL, CREATE_STAIRS, CREATE_CINDER_BLOCK_FIELD);
        JToggleButton ignoreDebrisButton = new JToggleButton("Ignore debris");
        ignoreDebrisButton.addChangeListener(e -> this.ignoreDebris.set(ignoreDebrisButton.isSelected()));
        DRCSimulationStarter simulationStarter = new DRCSimulationStarter((DRCRobotModel)robotModel, (CommonAvatarEnvironmentInterface)this.environment);
        simulationStarter.setRunMultiThreaded(true);
        simulationStarter.setInitializeEstimatorToActual(true);
        simulationStarter.setStartingLocationOffset((Tuple3DReadOnly)startingLocation.getPose().getPosition(), startingLocation.getPose().getYaw());
        simulationStarter.getSCSInitialSetup().setTimePerRecordTick(50.0 * robotModel.getControllerDT());
        simulationStarter.getSCSInitialSetup().setSimulationDataBufferSize(10);
        ArrayList<DRCSimulationTools.Modules> modulesToStart = new ArrayList<DRCSimulationTools.Modules>();
        modulesToStart.add(DRCSimulationTools.Modules.SIMULATION);
        modulesToStart.add(DRCSimulationTools.Modules.NETWORK_PROCESSOR);
        modulesToStart.add(DRCSimulationTools.Modules.SENSOR_MODULE);
        modulesToStart.add(DRCSimulationTools.Modules.FIDUCIAL_DETECTOR);
        modulesToStart.add(DRCSimulationTools.Modules.OBJECT_DETECTOR);
        modulesToStart.add(DRCSimulationTools.Modules.BEHAVIOR_MODULE);
        modulesToStart.add(DRCSimulationTools.Modules.FOOTSTEP_PLANNING_TOOLBOX);
        LogTools.info((String)"Starting simulation modules");
        String[] args = new String[]{"-m " + robotModel.getAtlasVersion().name()};
        DRCSimulationTools.startSimulation((SimulationStarterInterface)simulationStarter, null, (String[])args, null, modulesToStart);
        simulationStarter.getSimulationConstructionSet().addButton((AbstractButton)ignoreDebrisButton);
        BehaviorRegistry behaviorRegistry = JavaFXBehaviorUIRegistry.of((BehaviorDefinition)LookAndStepBehaviorUI.DEFINITION, (BehaviorDefinition[])new BehaviorDefinition[]{TraverseStairsBehavior.DEFINITION});
        BehaviorModule.createInterprocess((BehaviorRegistry)behaviorRegistry, (DRCRobotModel)robotModel);
        if (START_LOOK_AND_STEP_UI) {
            JavaFXBehaviorUI.createInterprocess((JavaFXBehaviorUIRegistry)JavaFXBehaviorUIRegistry.of((BehaviorDefinition)LookAndStepBehaviorUI.DEFINITION, (JavaFXBehaviorUIDefinition[])new JavaFXBehaviorUIDefinition[0]), (DRCRobotModel)robotModel, (String)"127.0.0.1");
        }
        ThreadTools.startAsDaemon(this::startPerceptionStack, (String)"PerceptionStack");
        this.wakeUpToolboxes(robotModel);
    }

    private void wakeUpToolboxes(AtlasRobotModel robotModel) {
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"toolboxes");
        String robotName = robotModel.getSimpleRobotName();
        IHMCROS2Publisher fiducialDetectorPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, ToolboxStateMessage.class, (ROS2Topic)FiducialDetectorToolboxModule.getInputTopic((String)robotName));
        IHMCROS2Publisher objectDetectorPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, ToolboxStateMessage.class, (ROS2Topic)ObjectDetectorToolboxModule.getInputTopic((String)robotName));
        new PausablePeriodicThread("ToolboxWaker", 1.0, () -> {
            ToolboxStateMessage wakeUpMessage = new ToolboxStateMessage();
            wakeUpMessage.setRequestedToolboxState((byte)0);
            fiducialDetectorPublisher.publish((Object)wakeUpMessage);
            objectDetectorPublisher.publish((Object)wakeUpMessage);
        }).start();
    }

    private void startPerceptionStack() {
        PlanarRegionsList environmentWithoutDebrisRegions = this.environment.getEnvironmentRegions();
        PlanarRegionsList environmentWithDebrisRegions = this.environment.getEnvironmentWithDebrisRegions();
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module");
        PlanarRegionSLAMMapper realsensePlanarRegionSLAM = new PlanarRegionSLAMMapper();
        AtlasRobotModel robotModel = this.createRobotModel();
        MultisenseHeadStereoSimulator multisense = new MultisenseHeadStereoSimulator(environmentWithDebrisRegions, (DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node, 20.0, 50000);
        RealsensePelvisSimulator realsense = new RealsensePelvisSimulator(environmentWithDebrisRegions, (DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node);
        double period = 3.0;
        new PeriodicPlanarRegionPublisher((ROS2NodeInterface)ros2Node, ROS2Tools.LIDAR_REA_REGIONS, period, () -> {
            multisense.setMap(this.ignoreDebris.get() ? environmentWithoutDebrisRegions : environmentWithDebrisRegions);
            return multisense.computeRegions();
        }).start();
        new PeriodicPlanarRegionPublisher((ROS2NodeInterface)ros2Node, ROS2Tools.REALSENSE_SLAM_REGIONS, period, () -> {
            boolean ignoreDebrisLocal = this.ignoreDebris.get();
            if (ignoreDebrisLocal != this.lastIgnoreDebrisValueUsedByRealsense) {
                realsensePlanarRegionSLAM.clear();
                this.lastIgnoreDebrisValueUsedByRealsense = ignoreDebrisLocal;
            }
            realsense.setMap(ignoreDebrisLocal ? environmentWithoutDebrisRegions : environmentWithDebrisRegions);
            return realsensePlanarRegionSLAM.update(realsense.computeRegions());
        }).start();
    }

    private AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = null;
        boolean createAdditionalContactPoints = false;
        if (CREATE_STAIRS) {
            simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 4, 3, false, false);
        }
        if (CREATE_PUSH_DOOR || CREATE_PULL_DOOR || CREATE_BARREL) {
            createAdditionalContactPoints = true;
        }
        return new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.SCS, false, (FootContactPoints<RobotSide>)simulationContactPoints, createAdditionalContactPoints);
    }

    public static void main(String[] args) {
        new AtlasPhaseOneDemo();
    }
}

