/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import java.net.URISyntaxException;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessor;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;

public class AtlasNetworkProcessorWithAutomaticDiagnosticRunner {
    public static void main(String[] args) throws URISyntaxException, JSAPException {
        AtlasRobotModel model;
        JSAP jsap = new JSAP();
        FlaggedOption robotModel = new FlaggedOption("robotModel").setLongFlag("model").setShortFlag('m').setRequired(true).setStringParser((StringParser)JSAP.STRING_PARSER);
        Switch runningOnRealRobot = new Switch("runningOnRealRobot").setLongFlag("realRobot");
        Switch runningOnGazebo = new Switch("runningOnGazebo").setLongFlag("gazebo");
        FlaggedOption leftHandHost = new FlaggedOption("leftHandHost").setLongFlag("lefthand").setShortFlag('l').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        FlaggedOption rightHandHost = new FlaggedOption("rightHandHost").setLongFlag("righthand").setShortFlag('r').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        robotModel.setHelp("Robot models: " + AtlasRobotModelFactory.robotModelsToString());
        jsap.registerParameter((Parameter)robotModel);
        jsap.registerParameter((Parameter)runningOnRealRobot);
        jsap.registerParameter((Parameter)runningOnGazebo);
        jsap.registerParameter((Parameter)leftHandHost);
        jsap.registerParameter((Parameter)rightHandHost);
        JSAPResult config = jsap.parse(args);
        if (config.success()) {
            try {
                RobotTarget target = config.getBoolean(runningOnRealRobot.getID()) ? RobotTarget.REAL_ROBOT : (config.getBoolean(runningOnGazebo.getID()) ? RobotTarget.GAZEBO : RobotTarget.SCS);
                model = AtlasRobotModelFactory.createDRCRobotModel(config.getString("robotModel"), target, true);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Incorrect robot model " + config.getString("robotModel"));
                System.out.println(jsap.getHelp());
                return;
            }
        } else {
            System.err.println("Invalid parameters");
            System.out.println(jsap.getHelp());
            return;
        }
        System.out.println("Using the " + model + " model");
        HumanoidNetworkProcessor networkProcessor = new HumanoidNetworkProcessor((DRCRobotModel)model, DomainFactory.PubSubImplementation.FAST_RTPS);
        LogTools.info((String)("ROS_MASTER_URI = " + networkProcessor.getOrCreateRosURI()));
        networkProcessor.setupRosModule();
        networkProcessor.setupBehaviorModule(true, true, 15.0);
        networkProcessor.setupShutdownHook();
        networkProcessor.start();
    }
}

