/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.JSAPException;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.DRCFlatGroundWalkingTrack;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationToolkit.controllers.OscillateFeetPerturber;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.ground.BumpyGroundProfile;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;

public class AtlasFlatGroundWalkingTrack {
    private static final DRCRobotModel defaultModelForGraphicSelector = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.SCS, false);
    private static final boolean USE_BUMPY_GROUND = false;
    private static final boolean USE_FEET_PERTURBER = false;

    public static void main(String[] args) throws JSAPException {
        AtlasRobotModel model = null;
        model = AtlasRobotModelFactory.selectSimulationModelFromFlag(args);
        if (model == null) {
            model = AtlasRobotModelFactory.selectModelFromGraphicSelector(defaultModelForGraphicSelector);
        }
        if (model == null) {
            throw new RuntimeException("No robot model selected");
        }
        DRCGuiInitialSetup guiInitialSetup = new DRCGuiInitialSetup(true, false);
        double groundHeight = 0.0;
        FlatGroundProfile groundProfile = new FlatGroundProfile(0.0);
        DRCSCSInitialSetup scsInitialSetup = new DRCSCSInitialSetup((GroundProfile3D)groundProfile, model.getSimulateDT());
        scsInitialSetup.setDrawGroundProfile(true);
        scsInitialSetup.setInitializeEstimatorToActual(true);
        double initialYaw = 0.3;
        DRCRobotInitialSetup robotInitialSetup = model.getDefaultRobotInitialSetup(0.0, initialYaw);
        boolean useVelocityAndHeadingScript = true;
        boolean cheatWithGroundHeightAtForFootstep = false;
        DRCFlatGroundWalkingTrack drcFlatGroundWalkingTrack = new DRCFlatGroundWalkingTrack(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, (DRCRobotModel)model);
    }

    private static void createOscillateFeetPerturber(DRCFlatGroundWalkingTrack drcFlatGroundWalkingTrack) {
        SimulationConstructionSet simulationConstructionSet = drcFlatGroundWalkingTrack.getSimulationConstructionSet();
        HumanoidFloatingRootJointRobot robot = drcFlatGroundWalkingTrack.getAvatarSimulation().getHumanoidFloatingRootJointRobot();
        int ticksPerPerturbation = 10;
        OscillateFeetPerturber oscillateFeetPerturber = new OscillateFeetPerturber(robot, simulationConstructionSet.getDT() * (double)ticksPerPerturbation);
        oscillateFeetPerturber.setTranslationMagnitude(new double[]{0.01, 0.015, 0.005});
        oscillateFeetPerturber.setRotationMagnitudeYawPitchRoll(new double[]{0.017, 0.012, 0.011});
        oscillateFeetPerturber.setTranslationFrequencyHz(RobotSide.LEFT, new double[]{0.0, 0.0, 3.3});
        oscillateFeetPerturber.setTranslationFrequencyHz(RobotSide.RIGHT, new double[]{0.0, 0.0, 1.3});
        oscillateFeetPerturber.setRotationFrequencyHzYawPitchRoll(RobotSide.LEFT, new double[]{0.0, 0.0, 7.3});
        oscillateFeetPerturber.setRotationFrequencyHzYawPitchRoll(RobotSide.RIGHT, new double[]{0.0, 0.0, 1.11});
        robot.setController((RobotController)oscillateFeetPerturber, ticksPerPerturbation);
    }

    private static BumpyGroundProfile createBumpyGroundProfile() {
        double xAmp1 = 0.05;
        double xFreq1 = 0.5;
        double xAmp2 = 0.01;
        double xFreq2 = 0.5;
        double yAmp1 = 0.01;
        double yFreq1 = 0.07;
        double yAmp2 = 0.05;
        double yFreq2 = 0.37;
        BumpyGroundProfile groundProfile = new BumpyGroundProfile(xAmp1, xFreq1, xAmp2, xFreq2, yAmp1, yFreq1, yAmp2, yFreq2);
        return groundProfile;
    }
}

