/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import controller_msgs.msg.dds.AbortWalkingMessage;
import controller_msgs.msg.dds.AtlasDesiredPumpPSIPacket;
import controller_msgs.msg.dds.AtlasLowLevelControlModeMessage;
import controller_msgs.msg.dds.BDIBehaviorCommandPacket;
import controller_msgs.msg.dds.PauseWalkingMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.atlas.AtlasLowLevelControlMode;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class AtlasDirectRobotInterface
implements RobotLowLevelMessenger {
    private final IHMCROS2Publisher<AtlasLowLevelControlModeMessage> lowLevelModePublisher;
    private final IHMCROS2Publisher<BDIBehaviorCommandPacket> bdiBehaviorPublisher;
    private final IHMCROS2Publisher<AtlasDesiredPumpPSIPacket> desiredPumpPSIPublisher;
    private final IHMCROS2Publisher<AbortWalkingMessage> abortWalkingPublisher;
    private final IHMCROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;

    public AtlasDirectRobotInterface(ROS2NodeInterface ros2Node, DRCRobotModel robotModel) {
        ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotModel.getSimpleRobotName());
        this.lowLevelModePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, AtlasLowLevelControlModeMessage.class, (ROS2Topic)inputTopic);
        this.bdiBehaviorPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, BDIBehaviorCommandPacket.class, (ROS2Topic)inputTopic);
        this.desiredPumpPSIPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, AtlasDesiredPumpPSIPacket.class, (ROS2Topic)inputTopic);
        this.abortWalkingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, AbortWalkingMessage.class, (ROS2Topic)inputTopic);
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PauseWalkingMessage.class, (ROS2Topic)inputTopic);
    }

    public void sendAbortWalkingRequest() {
        this.abortWalkingPublisher.publish((Object)new AbortWalkingMessage());
    }

    public void sendPauseWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(true);
        this.pauseWalkingPublisher.publish((Object)message);
    }

    public void sendContinueWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(false);
        this.pauseWalkingPublisher.publish((Object)message);
    }

    public void sendFreezeRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.FREEZE.toByte());
        this.lowLevelModePublisher.publish((Object)message);
    }

    public void sendStandRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.STAND_PREP.toByte());
        this.lowLevelModePublisher.publish((Object)message);
    }

    public void sendShutdownRequest() {
        BDIBehaviorCommandPacket message = HumanoidMessageTools.createBDIBehaviorCommandPacket((boolean)true);
        this.bdiBehaviorPublisher.publish((Object)message);
    }

    public void setHydraulicPumpPSI(int psi) {
        AtlasDesiredPumpPSIPacket message = new AtlasDesiredPumpPSIPacket();
        message.setDesiredPumpPsi(psi);
        this.desiredPumpPSIPublisher.publish((Object)message);
    }
}

