/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.JSAPException;
import ihmc_msgs.HandDesiredConfigurationRosMessage;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ros.internal.message.Message;
import org.ros.message.MessageFactory;
import org.ros.node.NodeConfiguration;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.DRCObstacleCourseStartingLocation;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.ros.ROSAPISimulator;
import us.ihmc.avatar.ros.subscriber.IHMCMsgToPacketSubscriber;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.PacketDestination;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.DefaultCommonAvatarEnvironment;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasDemo01ROSAPISimulator
extends ROSAPISimulator {
    private static final String ROBOT_NAME = "atlas";
    private static final String DEFAULT_ROBOT_MODEL = "ATLAS_UNPLUGGED_V5_NO_HANDS";
    private final AtlasRobotVersion robotVersion;

    public AtlasDemo01ROSAPISimulator(AtlasRobotModel robotModel, DRCStartingLocation startingLocation, String nameSpace, String tfPrefix, boolean runAutomaticDiagnosticRoutine, boolean disableViz, List<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> customSubscribers, List<Map.Entry<String, RosTopicPublisher<? extends Message>>> customPublishers) throws IOException {
        super((DRCRobotModel)robotModel, startingLocation, nameSpace, tfPrefix, runAutomaticDiagnosticRoutine, disableViz);
        this.robotVersion = robotModel.getAtlasVersion();
    }

    protected CommonAvatarEnvironmentInterface createEnvironment() {
        return new DefaultCommonAvatarEnvironment();
    }

    protected List<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> createCustomSubscribers(String nameSpace, PacketCommunicator communicator) {
        ArrayList<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> subscribers = new ArrayList<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>>();
        MessageFactory messageFactory = NodeConfiguration.newPrivate().getTopicMessageFactory();
        if (this.robotVersion.getHandModel().isHandSimulated()) {
            HandDesiredConfigurationRosMessage message = (HandDesiredConfigurationRosMessage)messageFactory.newFromType("ihmc_msgs/HandDesiredConfigurationRosMessage");
            IHMCMsgToPacketSubscriber sub = IHMCMsgToPacketSubscriber.createIHMCMsgToPacketSubscriber((Message)message, (PacketCommunicator)communicator, (int)PacketDestination.CONTROLLER.ordinal());
            AbstractMap.SimpleEntry<String, IHMCMsgToPacketSubscriber> pair = new AbstractMap.SimpleEntry<String, IHMCMsgToPacketSubscriber>(nameSpace + "/control/finger_state", sub);
            subscribers.add(pair);
        }
        return subscribers;
    }

    protected List<Map.Entry<String, RosTopicPublisher<? extends Message>>> createCustomPublishers(String nameSpace, PacketCommunicator communicator) {
        return null;
    }

    public static void main(String[] args) throws JSAPException, IOException {
        DRCObstacleCourseStartingLocation startingLocation;
        AtlasRobotModel robotModel;
        ROSAPISimulator.Options opt = AtlasDemo01ROSAPISimulator.parseArguments((String[])args);
        try {
            robotModel = opt.robotModel.equals("DEFAULT") ? AtlasRobotModelFactory.createDRCRobotModel(DEFAULT_ROBOT_MODEL, RobotTarget.SCS, false) : AtlasRobotModelFactory.createDRCRobotModel(opt.robotModel, RobotTarget.SCS, false);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Incorrect robot model " + opt.robotModel);
            System.out.println("Robot models: " + AtlasRobotModelFactory.robotModelsToString());
            return;
        }
        try {
            startingLocation = DRCObstacleCourseStartingLocation.valueOf((String)opt.startingLocation);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Incorrect starting location " + opt.startingLocation);
            System.out.println("Starting locations: " + DRCObstacleCourseStartingLocation.optionsToString());
            return;
        }
        String nameSpace = opt.nameSpace + "/" + ROBOT_NAME;
        new AtlasDemo01ROSAPISimulator(robotModel, (DRCStartingLocation)startingLocation, nameSpace, opt.tfPrefix, opt.runAutomaticDiagnosticRoutine, opt.disableViz, null, null);
    }
}

