/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.warmup.HumanoidControllerWarmup;
import us.ihmc.avatar.warmup.HumanoidControllerWarmupVisualizer;
import us.ihmc.avatar.warmup.HumanoidControllerWarumupTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;

public class AtlasControllerWarmup
extends HumanoidControllerWarmup {
    public AtlasControllerWarmup() {
        this(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS);
    }

    public AtlasControllerWarmup(AtlasRobotVersion version) {
        super((DRCRobotModel)new AtlasRobotModel(version, RobotTarget.SCS, true));
    }

    protected void runWarmup() {
        HumanoidReferenceFrames referenceFrames = this.getReferenceFrames();
        FullHumanoidRobotModel fullRobotModel = this.getFullRobotModel();
        this.getYoVariable("FootAssumeFootBarelyLoaded").setValueFromDouble(1.0);
        this.getYoVariable("FootAssumeCopOnEdge").setValueFromDouble(1.0);
        this.getYoVariable("maxICPErrorBeforeSingleSupportForwardX").setValueFromDouble(Double.POSITIVE_INFINITY);
        this.getYoVariable("maxICPErrorBeforeSingleSupportBackwardX").setValueFromDouble(Double.POSITIVE_INFINITY);
        this.getYoVariable("maxICPErrorBeforeSingleSupportInnerY").setValueFromDouble(Double.POSITIVE_INFINITY);
        this.getYoVariable("maxICPErrorBeforeSingleSupportOuterY").setValueFromDouble(Double.POSITIVE_INFINITY);
        this.simulate(1.0);
        for (int i = 0; i < 5; ++i) {
            this.submitMessage((Settable)HumanoidControllerWarumupTools.createStepsInPlace((HumanoidReferenceFrames)referenceFrames));
            this.simulate(1.5);
            for (RobotSide side : RobotSide.values) {
                this.submitMessage((Settable)HumanoidControllerWarumupTools.createArmMessage((FullHumanoidRobotModel)fullRobotModel, (RobotSide)side));
            }
            this.submitMessage((Settable)HumanoidControllerWarumupTools.createChestMessage((HumanoidReferenceFrames)referenceFrames));
            this.simulate(1.0);
        }
    }

    public static void main(String[] args) {
        AtlasControllerWarmup atlasControllerWarmup = new AtlasControllerWarmup();
        HumanoidFloatingRootJointRobot robot = atlasControllerWarmup.getRobotModel().createHumanoidFloatingRootJointRobot(false);
        HumanoidControllerWarmupVisualizer.runAndVisualizeWarmup((HumanoidControllerWarmup)atlasControllerWarmup, (FloatingRootJointRobot)robot);
    }
}

