/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.behaviors.coordinator.AtlasBuildingExplorationBehaviorUI;
import us.ihmc.atlas.behaviors.tools.AtlasSimulationBasics;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.environments.PhaseOneDemoEnvironment;
import us.ihmc.avatar.simulationStarter.DRCSimulationStarter;
import us.ihmc.avatar.simulationStarter.DRCSimulationTools;
import us.ihmc.avatar.simulationStarter.SimulationStarterInterface;
import us.ihmc.behaviors.simulation.EnvironmentInitialSetup;
import us.ihmc.behaviors.tools.PlanarRegionSLAMMapper;
import us.ihmc.behaviors.tools.perception.MultisenseHeadStereoSimulator;
import us.ihmc.behaviors.tools.perception.PeriodicPlanarRegionPublisher;
import us.ihmc.behaviors.tools.perception.RealsensePelvisSimulator;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;

public class AtlasBuildingExplorationDemo
extends AtlasSimulationBasics {
    private static boolean USE_KINEMATICS_SIMULATION = Boolean.parseBoolean(System.getProperty("use.kinematics.simulation", "false"));
    private static PhaseOneDemoEnvironment.StartingLocation STARTING_LOCATION = PhaseOneDemoEnvironment.StartingLocation.values()[Integer.parseInt(System.getProperty("starting.location", "1"))];
    private static boolean CREATE_PUSH_DOOR = Boolean.parseBoolean(System.getProperty("create.push.door", "true"));
    private static boolean CREATE_PULL_DOOR = Boolean.parseBoolean(System.getProperty("create.pull.door", "true"));
    private static boolean CREATE_DEBRIS = Boolean.parseBoolean(System.getProperty("create.debris", "false"));
    private static boolean CREATE_BARREL = Boolean.parseBoolean(System.getProperty("create.barrel", "false"));
    private static boolean CREATE_STAIRS = Boolean.parseBoolean(System.getProperty("create.stairs", "true"));
    private static boolean CREATE_CINDER_BLOCK_FIELD = Boolean.parseBoolean(System.getProperty("create.cinder.block.field", "true"));
    private final AtomicBoolean ignoreDebris = new AtomicBoolean(false);
    private final PhaseOneDemoEnvironment environment = new PhaseOneDemoEnvironment(CREATE_PUSH_DOOR, CREATE_PULL_DOOR, CREATE_DEBRIS, CREATE_BARREL, CREATE_STAIRS, CREATE_CINDER_BLOCK_FIELD);
    private boolean lastIgnoreDebrisValueUsedByRealsense = true;

    public AtlasBuildingExplorationDemo() {
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(() -> ((PhaseOneDemoEnvironment)this.environment).getDebrisRegions(), (CommonAvatarEnvironmentInterface)this.environment, STARTING_LOCATION.getPose().getZ(), STARTING_LOCATION.getPose().getYaw(), STARTING_LOCATION.getPose().getX(), STARTING_LOCATION.getPose().getY()));
        this.selectEnvironment();
        if (CREATE_STAIRS) {
            this.CREATE_MORE_FOOT_CONTACT_POINTS = true;
            this.numberOfContactPointsX = 4;
            this.numberOfContactPointsY = 3;
        }
        if (CREATE_PUSH_DOOR || CREATE_PULL_DOOR || CREATE_BARREL) {
            this.CREATE_HAND_CONTACT_POINTS = true;
        }
        AtlasRobotModel robotModel = this.createRobotModel();
        DRCSimulationStarter simulationStarter = new DRCSimulationStarter((DRCRobotModel)robotModel, (CommonAvatarEnvironmentInterface)this.environment);
        simulationStarter.setPubSubImplementation(COMMUNICATION_MODE_ROS2.getPubSubImplementation());
        simulationStarter.setRunMultiThreaded(true);
        simulationStarter.setInitializeEstimatorToActual(true);
        simulationStarter.setLogToFile(LOG_TO_FILE);
        simulationStarter.setStartingLocationOffset((Tuple3DReadOnly)STARTING_LOCATION.getPose().getPosition(), STARTING_LOCATION.getPose().getYaw());
        simulationStarter.getSCSInitialSetup().setTimePerRecordTick(50.0 * robotModel.getControllerDT());
        simulationStarter.getSCSInitialSetup().setSimulationDataBufferSize(10);
        ArrayList<DRCSimulationTools.Modules> modulesToStart = new ArrayList<DRCSimulationTools.Modules>();
        if (!USE_KINEMATICS_SIMULATION) {
            modulesToStart.add(DRCSimulationTools.Modules.SIMULATION);
            modulesToStart.add(DRCSimulationTools.Modules.SENSOR_MODULE);
        }
        modulesToStart.add(DRCSimulationTools.Modules.NETWORK_PROCESSOR);
        modulesToStart.add(DRCSimulationTools.Modules.FIDUCIAL_DETECTOR);
        modulesToStart.add(DRCSimulationTools.Modules.OBJECT_DETECTOR);
        modulesToStart.add(DRCSimulationTools.Modules.FOOTSTEP_PLANNING_TOOLBOX);
        LogTools.info((String)"Starting simulation modules");
        String[] args = new String[]{"-m " + robotModel.getAtlasVersion().name()};
        DRCSimulationTools.startSimulation((SimulationStarterInterface)simulationStarter, null, (String[])args, null, modulesToStart);
        if (USE_KINEMATICS_SIMULATION) {
            ThreadTools.startAsDaemon(this::lidarAndCameraSimulator, (String)"LidarAndCamera");
            this.kinematicSimulation();
        } else {
            JToggleButton ignoreDebrisButton = new JToggleButton("Ignore debris");
            ignoreDebrisButton.addChangeListener(e -> this.ignoreDebris.set(ignoreDebrisButton.isSelected()));
            simulationStarter.getSimulationConstructionSet().addButton((AbstractButton)ignoreDebrisButton);
            simulationStarter.getSimulationConstructionSet().skipLoadingDefaultConfiguration();
            simulationStarter.getSimulationConstructionSet().setupGraph("t");
        }
        LogTools.info((String)"Starting building exploration behavior");
        AtlasBuildingExplorationBehaviorUI.start(this.createRobotModel(), COMMUNICATION_MODE_ROS2, COMMUNICATION_MODE_MESSAGER);
        ThreadTools.startAsDaemon(this::startPerceptionStack, (String)"PerceptionStack");
    }

    private void startPerceptionStack() {
        PlanarRegionsList environmentWithoutDebrisRegions = this.environment.getEnvironmentRegions();
        PlanarRegionsList environmentWithDebrisRegions = this.environment.getEnvironmentWithDebrisRegions();
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)COMMUNICATION_MODE_ROS2.getPubSubImplementation(), (String)"REA_module");
        PlanarRegionSLAMMapper realsensePlanarRegionSLAM = new PlanarRegionSLAMMapper();
        AtlasRobotModel robotModel = this.createRobotModel();
        double range = 20.0;
        int sphereScanSize = 50000;
        MultisenseHeadStereoSimulator multisense = new MultisenseHeadStereoSimulator(environmentWithDebrisRegions, (DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node, range, sphereScanSize);
        RealsensePelvisSimulator realsense = new RealsensePelvisSimulator(environmentWithDebrisRegions, (DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node);
        double period = 3.0;
        new PeriodicPlanarRegionPublisher((ROS2NodeInterface)ros2Node, ROS2Tools.LIDAR_REA_REGIONS, period, () -> {
            multisense.setMap(this.ignoreDebris.get() ? environmentWithoutDebrisRegions : environmentWithDebrisRegions);
            return multisense.computeRegions();
        }).start();
        new PeriodicPlanarRegionPublisher((ROS2NodeInterface)ros2Node, ROS2Tools.REALSENSE_SLAM_REGIONS, period, () -> {
            boolean ignoreDebrisLocal = this.ignoreDebris.get();
            if (ignoreDebrisLocal != this.lastIgnoreDebrisValueUsedByRealsense) {
                realsensePlanarRegionSLAM.clear();
                this.lastIgnoreDebrisValueUsedByRealsense = ignoreDebrisLocal;
            }
            realsense.setMap(ignoreDebrisLocal ? environmentWithoutDebrisRegions : environmentWithDebrisRegions);
            return realsensePlanarRegionSLAM.update(realsense.computeRegions());
        }).start();
    }

    @Override
    protected boolean destroy() {
        boolean destroy = super.destroy();
        if (destroy) {
            // empty if block
        }
        return destroy;
    }

    public static void main(String[] args) {
        AtlasSimulationBasics.runOrLogToFile(AtlasBuildingExplorationDemo.class);
    }
}

