/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.html;

import java.util.HashMap;
import java.util.Map;
import us.fatehi.utility.Color;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.Tag;

public final class TagBuilder {
    private final String tag;
    private final Map<String, String> attributes;
    private String styleClass;
    private int characterWidth;
    private Alignment align;
    private String text;
    private boolean escapeText;
    private Color bgColor;
    private boolean emphasizeText;
    private boolean indent;

    public static TagBuilder anchor() {
        return new TagBuilder("a");
    }

    public static TagBuilder span() {
        return new TagBuilder("span");
    }

    public static TagBuilder tableHeaderCell() {
        return new TagBuilder("th");
    }

    public static TagBuilder tableCell() {
        return new TagBuilder("td");
    }

    public static TagBuilder tableRow() {
        return new TagBuilder("tr").withIndent(true);
    }

    public static TagBuilder caption() {
        return new TagBuilder("caption").withIndent(true);
    }

    private TagBuilder(String tag) {
        this.tag = tag;
        this.attributes = new HashMap<String, String>();
    }

    public TagBuilder withIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public Tag make() {
        return new Tag(this.tag, this.text, this.escapeText, this.characterWidth, this.align, this.emphasizeText, this.styleClass, this.bgColor, this.indent, this.attributes);
    }

    public TagBuilder withStyleClass(String styleClass) {
        this.styleClass = styleClass;
        return this;
    }

    public TagBuilder withStyle(String style) {
        if (style != null) {
            this.attributes.put("style", style);
        }
        return this;
    }

    public TagBuilder withWidth(int characterWidth) {
        this.characterWidth = characterWidth;
        return this;
    }

    public TagBuilder withAlignment(Alignment align) {
        this.align = align;
        return this;
    }

    public TagBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public TagBuilder withEscapedText(String text) {
        this.text = text;
        this.escapeText = true;
        return this;
    }

    public TagBuilder withEscapedText(String text, boolean escapeText) {
        this.text = text;
        this.escapeText = escapeText;
        return this;
    }

    public TagBuilder withBackground(Color bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public TagBuilder withEmphasis() {
        this.emphasizeText = true;
        return this;
    }

    public TagBuilder withEmphasis(boolean emphasizeText) {
        this.emphasizeText = emphasizeText;
        return this;
    }

    public TagBuilder withColumnSpan(int columnSpan) {
        this.attributes.put("colspan", String.valueOf(columnSpan));
        return this;
    }

    public TagBuilder withHyperlink(String href) {
        if (Utility.isBlank(href)) {
            return this;
        }
        this.attributes.put("href", href);
        return this;
    }
}

