/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import us.fatehi.utility.Color;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.TagOutputFormat;

public class Tag {
    private final String tagName;
    private final String styleClass;
    private final int characterWidth;
    private final Alignment align;
    private final String text;
    private final boolean escapeText;
    private final Color bgColor;
    private final boolean emphasizeText;
    private final List<Tag> innerTags;
    private final Map<String, String> attributes;
    private final boolean indent;

    protected Tag(String tagName, String text, boolean escapeText, int characterWidth, Alignment align, boolean emphasizeText, String styleClass, Color bgColor, boolean indent, Map<String, String> attributes) {
        this.tagName = Objects.requireNonNull(tagName);
        this.styleClass = styleClass;
        this.text = text == null ? "" : text;
        this.escapeText = escapeText;
        this.characterWidth = characterWidth;
        this.align = align;
        this.bgColor = bgColor;
        this.emphasizeText = emphasizeText;
        this.indent = indent;
        this.innerTags = new ArrayList<Tag>();
        this.attributes = attributes;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String render(TagOutputFormat tagOutputFormat) {
        switch (tagOutputFormat) {
            case text: {
                return this.toPlainTextString();
            }
            case tsv: {
                return this.toTsvString();
            }
        }
        return this.toHtmlString();
    }

    public String addAttribute(String key, String value) {
        if (!Utility.isBlank(key) && !Utility.isBlank(value)) {
            return this.attributes.put(key, value);
        }
        return value;
    }

    public Tag addInnerTag(Tag tag) {
        if (tag != null) {
            this.innerTags.add(tag);
        }
        return this;
    }

    public String toString() {
        return this.getTagName();
    }

    private String escapeHtml(String text) {
        StringBuilder buffer = new StringBuilder(text.length() * 2);
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '>': {
                    buffer.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block5;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block5;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder(1024);
        if (this.indent) {
            buffer.append("\t");
        }
        buffer.append("<").append(this.getTagName());
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            buffer.append(" ").append(attribute.getKey()).append("='").append(attribute.getValue()).append("'");
        }
        if (this.bgColor != null && !this.bgColor.equals(Color.white)) {
            buffer.append(" bgcolor='").append(this.bgColor).append("'");
        }
        if (!Utility.isBlank(this.styleClass)) {
            buffer.append(" class='").append(this.styleClass).append("'");
        } else if (this.align != null && this.align != Alignment.inherit) {
            buffer.append(" align='").append((Object)this.align).append("'");
        }
        buffer.append(">");
        if (this.emphasizeText) {
            buffer.append("<b><i>");
        }
        if (this.innerTags.isEmpty()) {
            if (this.indent) {
                buffer.append(System.lineSeparator());
            }
            buffer.append(this.escapeText ? this.escapeHtml(this.text) : this.text);
        } else {
            buffer.append(System.lineSeparator());
            for (Tag innerTag : this.innerTags) {
                if (this.indent) {
                    buffer.append("\t");
                }
                buffer.append("\t").append(innerTag.render(TagOutputFormat.html)).append(System.lineSeparator());
            }
        }
        if (this.emphasizeText) {
            buffer.append("</i></b>");
        }
        if (this.indent) {
            buffer.append("\t");
        }
        buffer.append("</").append(this.getTagName()).append(">");
        return buffer.toString();
    }

    private String toTsvString() {
        if (this.innerTags.isEmpty()) {
            return this.text;
        }
        return this.toInnerTagsTsvString();
    }

    private String toPlainTextString() {
        if (this.innerTags.isEmpty()) {
            if (this.characterWidth > 0) {
                String format = String.format("%%%s%ds", this.align == Alignment.right ? "" : "-", this.characterWidth);
                return String.format(format, this.text);
            }
            return this.text;
        }
        return this.toInnerTagsPlainTextString();
    }

    public Tag firstInnerTag() {
        if (this.innerTags.isEmpty()) {
            return null;
        }
        return this.innerTags.get(0);
    }

    public Tag lastInnerTag() {
        if (this.innerTags.isEmpty()) {
            return null;
        }
        return this.innerTags.get(this.innerTags.size() - 1);
    }

    private String toInnerTagsPlainTextString() {
        return this.toInnerTagsPlainTextString(TagOutputFormat.text, "  ");
    }

    private String toInnerTagsTsvString() {
        return this.toInnerTagsPlainTextString(TagOutputFormat.tsv, "\t");
    }

    private String toInnerTagsPlainTextString(TagOutputFormat tagOutputFormat, String fieldSeparator) {
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i < this.innerTags.size(); ++i) {
            Tag cell = this.innerTags.get(i);
            if (i > 0) {
                buffer.append(fieldSeparator);
            }
            buffer.append(cell.render(tagOutputFormat));
        }
        return buffer.toString();
    }
}

