/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.graph;

import java.util.HashMap;
import java.util.Map;

public final class Vertex<T> {
    private final Map<String, Object> attributes;
    private final T value;

    Vertex(T value) {
        this.value = value;
        this.attributes = new HashMap<String, Object>();
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.value.toString();
    }

    <V> V getAttribute(String key) {
        return (V)this.attributes.get(key);
    }

    boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    void putAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

