/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import us.fatehi.utility.Utility;

public final class TemplatingUtility {
    private static final String DELIMITER_END = "}";
    private static final String DELIMITER_START = "${";

    public static String expandTemplate(String template) {
        return TemplatingUtility.expandTemplate(template, TemplatingUtility.propertiesMap(System.getProperties()));
    }

    public static String expandTemplate(String template, Map<String, String> variablesMap) {
        if (Utility.isBlank(template) || variablesMap == null) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template.length());
        int currentPosition = 0;
        while (true) {
            int delimiterStartPosition;
            if ((delimiterStartPosition = template.indexOf(DELIMITER_START, currentPosition)) == -1) {
                if (currentPosition == 0) {
                    return template;
                }
                buffer.append(template.substring(currentPosition));
                return buffer.toString();
            }
            buffer.append(template, currentPosition, delimiterStartPosition);
            int delimiterEndPosition = template.indexOf(DELIMITER_END, delimiterStartPosition);
            if (delimiterEndPosition > -1) {
                String key = template.substring(delimiterStartPosition += DELIMITER_START.length(), delimiterEndPosition);
                String value = variablesMap.get(key);
                if (value != null) {
                    buffer.append(value);
                } else {
                    buffer.append(DELIMITER_START).append(key).append(DELIMITER_END);
                }
                currentPosition = delimiterEndPosition + DELIMITER_END.length();
                continue;
            }
            buffer.append(DELIMITER_START);
            currentPosition = delimiterStartPosition + DELIMITER_START.length();
        }
    }

    public static Set<String> extractTemplateVariables(String template) {
        int right;
        int left;
        if (Utility.isBlank(template)) {
            return new HashSet<String>();
        }
        String shrunkTemplate = template;
        HashSet<String> keys = new HashSet<String>();
        while ((left = shrunkTemplate.indexOf(DELIMITER_START)) >= 0 && (right = shrunkTemplate.indexOf(DELIMITER_END, left + 2)) >= 0) {
            String propertyKey = shrunkTemplate.substring(left + 2, right);
            keys.add(propertyKey);
            shrunkTemplate = shrunkTemplate.substring(0, left) + shrunkTemplate.substring(right + 1);
        }
        return keys;
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    public static void substituteVariables(Map<String, String> variablesMap) {
        if (variablesMap != null && !variablesMap.isEmpty()) {
            for (Map.Entry<String, String> entry : variablesMap.entrySet()) {
                variablesMap.put(entry.getKey(), TemplatingUtility.expandTemplate(entry.getValue(), variablesMap));
            }
        }
    }

    private TemplatingUtility() {
    }
}

