/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.string.StringFormat;

public final class ObjectToString {
    private static final Logger LOGGER = Logger.getLogger(ObjectToString.class.getName());

    private static void appendFields(Object object, int indent, StringBuilder buffer) {
        if (object == null) {
            return;
        }
        for (Field field : ObjectToString.getFields(object)) {
            try {
                String fieldName = field.getName();
                Object fieldValue = field.get(object);
                Class<?> fieldType = field.getType();
                if (fieldValue != null && fieldType.isArray()) {
                    fieldValue = Arrays.toString((Object[])fieldValue);
                }
                buffer.append(ObjectToString.indent(indent)).append("  ").append(fieldName).append(": ");
                if (fieldType.isPrimitive() || fieldType.isEnum() || fieldValue instanceof String || fieldValue == null || ObjectToString.definesToString(fieldValue)) {
                    buffer.append(fieldValue);
                } else {
                    ObjectToString.appendObject(fieldValue, indent + 1, buffer);
                }
                buffer.append(System.lineSeparator());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e, new StringFormat("Could not access field <%s>", field));
            }
        }
    }

    private static void appendFooter(int indent, StringBuilder buffer) {
        buffer.append(ObjectToString.indent(indent)).append(']');
    }

    private static void appendHeader(Object object, int indent, StringBuilder buffer) {
        if (object != null) {
            buffer.append(ObjectToString.indent(indent)).append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object))).append('[').append(System.lineSeparator());
        }
    }

    private static void appendIterable(Iterator<?> iterator, String delimiter, StringBuilder buffer) {
        while (iterator.hasNext()) {
            Object item = iterator.next();
            buffer.append(item);
            if (!iterator.hasNext()) continue;
            buffer.append(delimiter);
        }
    }

    private static void appendObject(Object object, int indent, StringBuilder buffer) {
        Class<?> objectClass = object.getClass();
        if (Map.class.isAssignableFrom(objectClass)) {
            Set mapEntries = new TreeMap((Map)object).entrySet();
            for (Map.Entry mapEntry : mapEntries) {
                Object key = mapEntry.getKey();
                Object value = key != null && String.valueOf(key).equals("password") ? "*****" : mapEntry.getValue();
                buffer.append(System.lineSeparator()).append(ObjectToString.indent(indent)).append(key).append(": ").append(value);
            }
        } else if (Collection.class.isAssignableFrom(objectClass)) {
            ObjectToString.appendIterable(((Collection)object).iterator(), ", ", buffer);
        } else if (objectClass.isArray()) {
            ObjectToString.appendIterable(Arrays.asList((Object[])object).iterator(), ", ", buffer);
        } else if (objectClass.isEnum()) {
            buffer.append(object.toString());
        } else if (Arrays.asList(Integer.class, Long.class, Double.class, Float.class, Boolean.class, Character.class, Byte.class, Void.class, Short.class, String.class).contains(objectClass)) {
            buffer.append(object.toString());
        } else {
            ObjectToString.appendHeader(object, 0, buffer);
            ObjectToString.appendFields(object, indent, buffer);
            ObjectToString.appendFooter(indent, buffer);
        }
    }

    private static boolean definesToString(Object object) {
        boolean definesToString = false;
        Class<?>[] classes = ObjectToString.getClassHierarchy(object);
        if (classes.length > 0) {
            for (Class<?> clazz : classes) {
                try {
                    boolean bl = definesToString = clazz.getDeclaredMethod("toString", new Class[0]) != null;
                    if (!definesToString) continue;
                    break;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
        }
        return definesToString;
    }

    private static Class<?>[] getClassHierarchy(Object object) {
        ArrayList classHierarchy = new ArrayList();
        if (object != null) {
            Class<?> clazz = object.getClass();
            classHierarchy.add(clazz);
            while (clazz.getSuperclass() != null) {
                if ((clazz = clazz.getSuperclass()).getSuperclass() == null) continue;
                classHierarchy.add(clazz);
            }
        }
        return classHierarchy.toArray(new Class[classHierarchy.size()]);
    }

    private static Field[] getFields(Object object) {
        Class<?>[] classes = ObjectToString.getClassHierarchy(object);
        ArrayList<AccessibleObject> allFields = new ArrayList<AccessibleObject>();
        if (classes != null && classes.length > 0) {
            Class<?> clazz;
            Class<?>[] classArray = classes;
            int n = classArray.length;
            for (int i = 0; !(i >= n || (clazz = classArray[i]).isArray() || clazz.isPrimitive() || clazz.isEnum() || String.class.isAssignableFrom(clazz)); ++i) {
                AccessibleObject[] fields = clazz.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                allFields.addAll(Arrays.asList(fields));
            }
        }
        Iterator iterator = allFields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            int modifiers = field.getModifiers();
            if (!Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers)) continue;
            iterator.remove();
        }
        Collections.sort(allFields, (field1, field2) -> field1.getName().compareTo(field2.getName()));
        return allFields.toArray(new Field[allFields.size()]);
    }

    private static char[] indent(int indent) {
        if (indent >= 0) {
            char[] indentChars = new char[indent * 2];
            Arrays.fill(indentChars, ' ');
            return indentChars;
        }
        return new char[0];
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        boolean indent = false;
        StringBuilder buffer = new StringBuilder(1024);
        ObjectToString.appendObject(object, 0, buffer);
        return buffer.toString();
    }

    private ObjectToString() {
    }
}

