/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.string.ObjectToStringFormat;

public final class SchemaCrawlerUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawlerUtility.class.getName());

    public static Catalog getCatalog(Connection connection, SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkConnection(connection);
        LOGGER.log(Level.CONFIG, new ObjectToStringFormat(schemaCrawlerOptions));
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(connection);
        SchemaCrawler schemaCrawler = new SchemaCrawler(connection, schemaRetrievalOptions, schemaCrawlerOptions);
        Catalog catalog = schemaCrawler.crawl();
        return catalog;
    }

    public static ResultsColumns getResultsColumns(ResultSet resultSet) throws SchemaCrawlerException {
        try {
            SchemaCrawlerUtility.checkResultSet(resultSet);
            ResultsCrawler resultSetCrawler = new ResultsCrawler(resultSet);
            ResultsColumns resultsColumns = resultSetCrawler.crawl();
            return resultsColumns;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not retrieve result-set metadata", e);
        }
    }

    public static SchemaRetrievalOptions matchSchemaRetrievalOptions(Connection connection) throws SchemaCrawlerException {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaCrawlerUtility.buildSchemaRetrievalOptions(connection);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        return schemaRetrievalOptions;
    }

    private static SchemaRetrievalOptionsBuilder buildSchemaRetrievalOptions(Connection connection) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkConnection(connection);
        DatabaseConnectorRegistry registry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.lookupDatabaseConnector(connection);
        DatabaseServerType databaseServerType = dbConnector.getDatabaseServerType();
        LOGGER.log(Level.INFO, "Using database plugin for " + databaseServerType);
        String withoutDatabasePlugin = Config.getSystemConfigurationProperty("SC_WITHOUT_DATABASE_PLUGIN", "");
        if (!databaseServerType.isUnknownDatabaseSystem() && databaseServerType.getDatabaseSystemIdentifier().equalsIgnoreCase(withoutDatabasePlugin)) {
            dbConnector = DatabaseConnector.UNKNOWN;
        }
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = dbConnector.getSchemaRetrievalOptionsBuilder(connection);
        return schemaRetrievalOptionsBuilder;
    }

    private static void checkConnection(Connection connection) throws SchemaCrawlerException {
        try {
            DatabaseUtility.checkConnection(connection);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Bad database connection", e);
        }
    }

    private static void checkResultSet(ResultSet resultSet) throws SchemaCrawlerException {
        try {
            DatabaseUtility.checkResultSet(resultSet);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Bad result-set", e);
        }
    }

    private SchemaCrawlerUtility() {
    }
}

