/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.utility.PropertiesUtility;
import us.fatehi.utility.Color;
import us.fatehi.utility.RegularExpressionColorMap;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.ClasspathInputResource;
import us.fatehi.utility.ioresource.FileInputResource;

public class DatabaseObjectColorMap {
    public static final Color default_object_color = Color.fromHSV(0.0f, 0.0f, 0.95f);
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DatabaseObjectColorMap.class.getName());
    private static final String SCHEMACRAWLER_COLORMAP_PROPERTIES = "schemacrawler.colormap.properties";
    private final RegularExpressionColorMap colorMap;
    private final boolean noColors;

    public static DatabaseObjectColorMap initialize(boolean noColors) {
        Properties properties = new Properties();
        if (noColors) {
            return new DatabaseObjectColorMap(properties, noColors);
        }
        try {
            ClasspathInputResource classpathColorMap = new ClasspathInputResource("/schemacrawler.colormap.properties");
            properties.putAll((Map<?, ?>)PropertiesUtility.loadProperties(classpathColorMap));
        }
        catch (IOException e) {
            LOGGER.log(Level.CONFIG, "Could not load color map from CLASSPATH");
        }
        try {
            FileInputResource fileColorMap = new FileInputResource(Paths.get("./schemacrawler.colormap.properties", new String[0]));
            properties.putAll((Map<?, ?>)PropertiesUtility.loadProperties(fileColorMap));
        }
        catch (IOException e) {
            LOGGER.log(Level.CONFIG, "Could not load color map from file");
        }
        return new DatabaseObjectColorMap(properties, noColors);
    }

    private DatabaseObjectColorMap(Properties properties, boolean noColors) {
        this.noColors = noColors;
        this.colorMap = new RegularExpressionColorMap(properties);
    }

    public Color getColor(DatabaseObject dbObject) {
        Color tableColor;
        Objects.requireNonNull(dbObject, "No database object provided");
        if (this.noColors) {
            return default_object_color;
        }
        String schemaName = dbObject.getSchema().getFullName();
        Optional<Color> colorMatch = this.colorMap.match(schemaName);
        if (!colorMatch.isPresent()) {
            tableColor = this.generatePastelColor(schemaName);
            this.colorMap.putLiteral(schemaName, tableColor);
        } else {
            tableColor = colorMatch.get();
        }
        return tableColor;
    }

    private Color generatePastelColor(String text) {
        float hue;
        if (Utility.isBlank(text)) {
            hue = 0.123456f;
        } else {
            int hash = new StringBuilder(text).reverse().toString().hashCode();
            hue = (float)hash / 32771.0f % 1.0f;
        }
        float saturation = 0.15f;
        float brightness = 0.95f;
        Color color = Color.fromHSV(hue, 0.15f, 0.95f);
        return color;
    }
}

