/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.analysis.counts.TableRowCountsUtility;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.crawl.WeakAssociation;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.diagram.DiagramOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Color;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

public final class SchemaDotFormatter
extends BaseDotFormatter
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isBrief;

    public SchemaDotFormatter(SchemaTextDetailType schemaTextDetailType, DiagramOptions options, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions, identifierQuoteString);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isBrief = schemaTextDetailType == SchemaTextDetailType.brief;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
    }

    @Override
    public void handle(Routine routine) {
    }

    @Override
    public void handle(Sequence sequence) {
    }

    @Override
    public void handle(Synonym synonym) {
    }

    @Override
    public void handle(Table table) {
        String tableName = ((DiagramOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName(table) : this.identifiers.quoteFullName(table);
        String tableType = "[" + table.getTableType() + "]";
        Color tableNameBgColor = this.colorMap.getColor(table);
        int colspan = ((DiagramOptions)this.options).isShowOrdinalNumbers() ? 3 : 2;
        this.formattingHelper.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.formattingHelper.append("  \"").append(this.nodeId(table)).append("\" [").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" color=\"#888888\">").println();
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(tableName).withAlignment(Alignment.left).withEmphasis(true).withBackground(tableNameBgColor).withColumnSpan(colspan).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(tableType).withAlignment(Alignment.right).withBackground(tableNameBgColor).make()).render(TagOutputFormat.html)).println();
        this.printTableRemarks(table);
        this.printTableColumns(table.getColumns());
        if (this.isVerbose) {
            this.printTableColumns(new ArrayList<Column>(table.getHiddenColumns()));
        }
        this.printTableRowCount(table);
        this.formattingHelper.append("      </table>").println();
        this.formattingHelper.append("    >").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
        this.printForeignKeys(table);
        this.printWeakAssociations(table);
        this.formattingHelper.println();
        this.formattingHelper.println();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private String arrowhead(MetaDataUtility.ForeignKeyCardinality connectivity) {
        switch (connectivity) {
            case unknown: {
                return "box";
            }
            case zero_one: {
                return "teeodot";
            }
            case zero_many: {
                return "crowodot";
            }
            case one_one: {
                return "teetee";
            }
        }
        return "box";
    }

    private String[] getPortIds(Column column, boolean isNewNode) {
        String[] portIds = new String[2];
        if (!isNewNode) {
            portIds[0] = String.format("\"%s\":\"%s.start\"", this.nodeId((DatabaseObject)column.getParent()), this.nodeId(column));
            portIds[1] = String.format("\"%s\":\"%s.end\"", this.nodeId((DatabaseObject)column.getParent()), this.nodeId(column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.printNewNode(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private String printColumnReference(String fkName, ColumnReference columnRef, MetaDataUtility.ForeignKeyCardinality fkCardinality, boolean isFkColumnFiltered) {
        boolean isForeignKey = columnRef instanceof ForeignKeyColumnReference;
        Column primaryKeyColumn = columnRef.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnRef.getForeignKeyColumn();
        String[] pkPortIds = this.getPortIds(primaryKeyColumn, false);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn, isFkColumnFiltered);
        DiagramOptions diagramOptions = (DiagramOptions)this.options;
        String pkSymbol = diagramOptions.isShowPrimaryKeyCardinality() ? "teetee" : "none";
        String fkSymbol = diagramOptions.isShowForeignKeyCardinality() ? this.arrowhead(fkCardinality) : "none";
        String style = isForeignKey ? "solid" : "dashed";
        String associationName = ((DiagramOptions)this.options).isHideForeignKeyNames() || !isForeignKey ? "" : fkName;
        return String.format("  %s:w -> %s:e [label=<%s> style=\"%s\" dir=\"both\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", fkPortIds[0], pkPortIds[1], associationName, style, pkSymbol, fkSymbol);
    }

    private void printForeignKeys(Table table) {
        this.printForeignKeys(table, table.getForeignKeys());
    }

    private void printForeignKeys(Table table, Collection<? extends BaseForeignKey<?>> foreignKeys) {
        for (BaseForeignKey<?> foreignKey : foreignKeys) {
            MetaDataUtility.ForeignKeyCardinality fkCardinality = MetaDataUtility.findForeignKeyCardinality(foreignKey);
            for (ColumnReference columnRef : foreignKey) {
                Table referencedTable = (Table)columnRef.getForeignKeyColumn().getParent();
                boolean isForeignKeyFiltered = referencedTable.getAttribute("schemacrawler.table.no_grep_match", false);
                if (isForeignKeyFiltered) continue;
                boolean isFkColumnFiltered = referencedTable.getAttribute("schemacrawler.table.filtered_out", false);
                if (!table.equals(columnRef.getPrimaryKeyColumn().getParent())) continue;
                this.formattingHelper.append(this.printColumnReference(this.identifiers.quoteName(foreignKey.getName()), columnRef, fkCardinality, isFkColumnFiltered));
            }
        }
    }

    private String printNewNode(Column column) {
        String nodeId = "\"" + this.nodeId(column) + "\"";
        String columnName = ((DiagramOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName(column) : this.identifiers.quoteFullName(column);
        String columnNode = String.format("  %s [label=<%s>];%n", nodeId, columnName);
        this.formattingHelper.append(columnNode);
        return nodeId;
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isAutoIncremented()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("auto-incremented").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnGenerated(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isGenerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("generated").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnEnumValues(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.getColumnDataType().isEnumerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        String enumValues = String.format("'%s'", String.join((CharSequence)"', ", column.getColumnDataType().getEnumValues()));
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(enumValues).withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnHidden(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isHidden()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("hidden").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks() || ((DiagramOptions)this.options).isHideRemarks()) {
            return;
        }
        Tag remarksRow = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            remarksRow.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        remarksRow.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(column.getRemarks()).withAlignment(Alignment.left).make());
        this.formattingHelper.append(remarksRow.render(TagOutputFormat.html)).println();
    }

    private void printTableColumns(List<Column> columns) {
        if (columns.isEmpty()) {
            return;
        }
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort(((DiagramOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            if (this.isBrief && !this.isColumnSignificant(column)) continue;
            String columnTypeName = ((DiagramOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getJavaSqlType().getName() : column.getColumnDataType().getDatabaseSpecificTypeName();
            String columnType = columnTypeName + column.getWidth();
            String nullable = this.columnNullable(columnTypeName, column.isNullable());
            String columnDetails = columnType + nullable;
            boolean emphasize = column.isPartOfPrimaryKey();
            Tag row = TagBuilder.tableRow().make();
            if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
                String ordinalNumberString = String.valueOf(column.getOrdinalPosition());
                row.addInnerTag(TagBuilder.tableCell().withEscapedText(ordinalNumberString).withAlignment(Alignment.right).make());
            }
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(this.identifiers.quoteName(column.getName())).withAlignment(Alignment.left).withEmphasis(emphasize).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(columnDetails).withAlignment(Alignment.left).make());
            row.firstInnerTag().addAttribute("port", this.nodeId(column) + ".start");
            row.lastInnerTag().addAttribute("port", this.nodeId(column) + ".end");
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
            this.printTableColumnEnumValues(column);
            this.printTableColumnHidden(column);
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnGenerated(column);
            this.printTableColumnRemarks(column);
        }
    }

    private void printTableRemarks(Table table) {
        if (table == null || !table.hasRemarks() || ((DiagramOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(table.getRemarks()).withAlignment(Alignment.left).withColumnSpan(3).make()).render(TagOutputFormat.html)).println();
    }

    private void printTableRowCount(Table table) {
        if (!((DiagramOptions)this.options).isShowRowCounts() || table == null || !TableRowCountsUtility.hasRowCount(table)) {
            return;
        }
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(TableRowCountsUtility.getRowCountMessage(table)).withAlignment(Alignment.right).withColumnSpan(3).make()).render(TagOutputFormat.html)).println();
    }

    private void printWeakAssociations(Table table) {
        if (!((DiagramOptions)this.options).isShowWeakAssociations()) {
            return;
        }
        Collection<WeakAssociation> weakFks = table.getWeakAssociations();
        this.printForeignKeys(table, weakFks);
    }
}

