/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Collection;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.Property;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;

public abstract class BaseTabularFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected BaseTabularFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions, identifierQuoteString);
    }

    @Override
    public void begin() {
        if (!this.options.isNoHeader()) {
            this.formattingHelper.writeDocumentStart();
        }
    }

    @Override
    public void handle(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        String title = this.outputOptions.getTitle();
        if (!Utility.isBlank(title)) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.title, title);
        }
        if (this.options.isNoInfo() || this.options.isNoSchemaCrawlerInfo() && !this.options.isShowDatabaseInfo() && !this.options.isShowJdbcDriverInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
        this.formattingHelper.writeObjectStart();
        if (!this.options.isNoSchemaCrawlerInfo()) {
            this.formattingHelper.writeNameValueRow("generated by", crawlInfo.getSchemaCrawlerVersion().toString(), Alignment.inherit);
            this.formattingHelper.writeNameValueRow("generated on", crawlInfo.getCrawlTimestamp(), Alignment.inherit);
        }
        if (this.options.isShowDatabaseInfo()) {
            this.formattingHelper.writeNameValueRow("database version", crawlInfo.getDatabaseVersion().toString(), Alignment.inherit);
        }
        if (this.options.isShowJdbcDriverInfo()) {
            this.formattingHelper.writeNameValueRow("driver version", crawlInfo.getJdbcDriverVersion().toString(), Alignment.inherit);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public final void handle(DatabaseInfo dbInfo) {
        if (!this.printVerboseDatabaseInfo || !this.options.isShowDatabaseInfo() || dbInfo == null) {
            return;
        }
        Collection<Property> serverInfo = dbInfo.getServerInfo();
        if (!serverInfo.isEmpty()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Server Information");
            this.formattingHelper.writeObjectStart();
            for (Property property : serverInfo) {
                String name = property.getName();
                Object value = property.getValue();
                this.formattingHelper.writeNameValueRow(name, ObjectToString.toString(value), Alignment.inherit);
            }
            this.formattingHelper.writeObjectEnd();
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("database product name", dbInfo.getProductName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database product version", dbInfo.getProductVersion(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database user name", dbInfo.getUserName(), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
        Collection<DatabaseProperty> dbProperties = dbInfo.getProperties();
        if (!dbProperties.isEmpty()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Characteristics");
            this.formattingHelper.writeObjectStart();
            for (DatabaseProperty property : dbProperties) {
                String name = property.getDescription();
                Object value = property.getValue();
                this.formattingHelper.writeNameValueRow(name, ObjectToString.toString(value), Alignment.inherit);
            }
            this.formattingHelper.writeObjectEnd();
        }
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (!this.printVerboseDatabaseInfo || !this.options.isShowJdbcDriverInfo() || driverInfo == null) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("driver name", driverInfo.getProductName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver version", driverInfo.getProductVersion(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver class name", driverInfo.getDriverClassName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("url", driverInfo.getConnectionUrl(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("is JDBC compliant", Boolean.toString(driverInfo.isJdbcCompliant()), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
        Collection<JdbcDriverProperty> jdbcDriverProperties = driverInfo.getDriverProperties();
        if (!jdbcDriverProperties.isEmpty()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Properties");
            for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                this.formattingHelper.writeObjectStart();
                this.printJdbcDriverProperty(driverProperty);
                this.formattingHelper.writeObjectEnd();
            }
        }
    }

    @Override
    public final void handleHeaderEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleHeaderStart() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoStart() throws SchemaCrawlerException {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || !this.options.isShowDatabaseInfo() && !this.options.isShowJdbcDriverInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (!this.options.isNoFooter()) {
            this.formattingHelper.writeDocumentEnd();
        }
        super.end();
    }

    private void printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        String required;
        String details = required = (driverProperty.isRequired() ? "" : "not ") + "required";
        if (driverProperty.getChoices() != null && !driverProperty.getChoices().isEmpty()) {
            details = details + "; choices " + driverProperty.getChoices();
        }
        String value = driverProperty.getValue();
        this.formattingHelper.writeNameRow(driverProperty.getName(), "[driver property]");
        this.formattingHelper.writeDescriptionRow(driverProperty.getDescription());
        this.formattingHelper.writeDescriptionRow(details);
        this.formattingHelper.writeDetailRow("", "value", ObjectToString.toString(value));
    }
}

