/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.diagram;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.tools.integration.diagram.DiagramOutputFormat;
import us.fatehi.utility.ProcessExecutor;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.FileContents;
import us.fatehi.utility.string.StringFormat;

public final class GraphvizUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphvizUtility.class.getName());

    public static boolean isGraphvizAvailable() {
        Integer exitCode;
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.add("-V");
        LOGGER.log(Level.FINE, new StringFormat("Checking if Graphviz is available:%n%s", ((Object)command).toString()));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
            LOGGER.log(Level.CONFIG, new StringFormat("Graphviz stdout:%n%s", new FileContents(processExecutor.getProcessOutput())));
            LOGGER.log(Level.CONFIG, new StringFormat("Graphviz stderr:%n%s", new FileContents(processExecutor.getProcessError())));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not execute Graphviz command", (Throwable)e);
            LOGGER.log(Level.WARNING, new StringFormat("Graphviz stderr:%n%s", new FileContents(processExecutor.getProcessError())));
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        LOGGER.log(Level.CONFIG, new StringFormat("Is Graphviz available? %s", successful));
        return successful;
    }

    public static boolean isGraphvizJavaAvailable(DiagramOutputFormat diagramOutputFormat) {
        String className = "guru.nidi.graphviz.engine.Graphviz";
        boolean hasClass = Utility.isClassAvailable("guru.nidi.graphviz.engine.Graphviz");
        boolean supportsFormat = EnumSet.of(DiagramOutputFormat.svg, DiagramOutputFormat.png, DiagramOutputFormat.ps, DiagramOutputFormat.xdot, DiagramOutputFormat.plain).contains(diagramOutputFormat);
        LOGGER.log(Level.CONFIG, new StringFormat("Checking if diagram can be generated -  can load <%s> = <%b>,  can generate format <%s> = <%b>", "guru.nidi.graphviz.engine.Graphviz", hasClass, diagramOutputFormat.getDescription(), supportsFormat));
        return hasClass && supportsFormat;
    }

    private GraphvizUtility() {
    }
}

