/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import us.fatehi.utility.Utility;

final class Commands
implements Serializable,
Iterable<String> {
    private static final long serialVersionUID = -3450943894546747834L;
    private final List<String> commands = new ArrayList<String>();

    Commands(String commandsList) {
        if (!Utility.isBlank(commandsList)) {
            String[] commandStrings = commandsList.split(",");
            this.commands.addAll(Arrays.asList(commandStrings));
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.commands.iterator();
    }

    public String toString() {
        return this.commands.toString();
    }

    boolean hasMultipleCommands() {
        return this.commands.size() > 1;
    }

    boolean isEmpty() {
        return this.commands.isEmpty();
    }

    boolean isFirstCommand(String command) {
        if (command != null && !this.isEmpty()) {
            String firstCommand = this.commands.get(0);
            return firstCommand.equals(command);
        }
        return false;
    }

    boolean isLastCommand(String command) {
        if (command != null && !this.isEmpty()) {
            String lastCommand = this.commands.get(this.commands.size() - 1);
            return lastCommand.equals(command);
        }
        return false;
    }
}

