/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.databaseconnector.UnknownDatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.utility.PropertiesUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.InputResource;

public abstract class DatabaseConnector
implements Options {
    public static final DatabaseConnector UNKNOWN = new UnknownDatabaseConnector();
    private final InputResource configResource;
    private final DatabaseServerType dbServerType;
    private final BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuilderForConnection;

    protected DatabaseConnector(DatabaseServerType dbServerType, InputResource configResource, BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuilderForConnection) {
        this.dbServerType = Objects.requireNonNull(dbServerType, "No database server type provided");
        this.configResource = Objects.requireNonNull(configResource, "No config resource provided");
        this.informationSchemaViewsBuilderForConnection = informationSchemaViewsBuilderForConnection;
    }

    public final Config getConfig() {
        return PropertiesUtility.loadConfig(this.configResource);
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public EnumDataTypeHelper getEnumDataTypeHelper() {
        return EnumDataTypeHelper.NO_OP_ENUM_DATA_TYPE_HELPER;
    }

    public SchemaRetrievalOptionsBuilder getSchemaRetrievalOptionsBuilder(Connection connection) {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withFunction(this.informationSchemaViewsBuilderForConnection, connection).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().withDatabaseServerType(this.dbServerType).withEnumDataTypeHelper(this.getEnumDataTypeHelper()).withInformationSchemaViews(informationSchemaViews).fromConnnection(connection);
        return schemaRetrievalOptionsBuilder;
    }

    public DatabaseConnectionSource newDatabaseConnectionSource(DatabaseConnectorOptions databaseConnectorOptions) throws SchemaCrawlerException {
        Objects.requireNonNull(databaseConnectorOptions, "No database connection options provided");
        DatabaseConnectionSource connectionOptions = databaseConnectorOptions.toDatabaseConnectionSource(this.getConfig());
        return connectionOptions;
    }

    public final boolean supportsUrl(String url) {
        if (Utility.isBlank(url)) {
            return false;
        }
        return this.supportsUrlPredicate().test(url);
    }

    public String toString() {
        if (this.dbServerType.isUnknownDatabaseSystem()) {
            return "Database connector for unknown database system type";
        }
        return "Database connector for " + this.dbServerType;
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand(this.dbServerType.getDatabaseSystemIdentifier(), "** Connect to " + this.dbServerType.getDatabaseSystemName());
        return pluginCommand;
    }

    protected abstract Predicate<String> supportsUrlPredicate();
}

