/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.options.Config;

public class SchemaCrawlerCatalogLoader
implements CatalogLoader {
    private final String databaseSystemIdentifier;
    private SchemaRetrievalOptions schemaRetrievalOptions;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private Config additionalConfiguration;
    private Connection connection;

    public SchemaCrawlerCatalogLoader() {
        this.databaseSystemIdentifier = null;
    }

    protected SchemaCrawlerCatalogLoader(String databaseSystemIdentifier) {
        this.databaseSystemIdentifier = Objects.requireNonNull(databaseSystemIdentifier, "No database system identifier provided");
    }

    @Override
    public Config getAdditionalConfiguration() {
        if (this.additionalConfiguration == null) {
            return new Config();
        }
        return this.additionalConfiguration;
    }

    @Override
    public void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = additionalConfiguration;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public String getDatabaseSystemIdentifier() {
        return this.databaseSystemIdentifier;
    }

    @Override
    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        if (this.schemaCrawlerOptions == null) {
            return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        }
        return this.schemaCrawlerOptions;
    }

    @Override
    public void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions;
    }

    @Override
    public SchemaRetrievalOptions getSchemaRetrievalOptions() {
        if (this.schemaRetrievalOptions == null) {
            return SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
        }
        return this.schemaRetrievalOptions;
    }

    @Override
    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    @Override
    public Catalog loadCatalog() throws Exception {
        Objects.requireNonNull(this.connection, "No connection provided");
        Objects.requireNonNull(this.schemaRetrievalOptions, "No database specific overrides provided");
        SchemaCrawler schemaCrawler = new SchemaCrawler(this.connection, this.schemaRetrievalOptions, this.schemaCrawlerOptions);
        Catalog catalog = schemaCrawler.crawl();
        return catalog;
    }
}

