/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;

public final class SchemaRetrievalOptions
implements Options {
    private final DatabaseServerType dbServerType;
    private final String identifierQuoteString;
    private final Identifiers identifiers;
    private final InformationSchemaViews informationSchemaViews;
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private final TypeMap typeMap;
    private final EnumDataTypeHelper enumDataTypeHelper;
    EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy> metadataRetrievalStrategyMap;

    protected SchemaRetrievalOptions(SchemaRetrievalOptionsBuilder builder) {
        SchemaRetrievalOptionsBuilder bldr = builder == null ? SchemaRetrievalOptionsBuilder.builder() : builder;
        this.dbServerType = bldr.dbServerType;
        this.supportsSchemas = bldr.supportsSchemas;
        this.supportsCatalogs = bldr.supportsCatalogs;
        this.identifierQuoteString = bldr.identifierQuoteString;
        this.informationSchemaViews = bldr.informationSchemaViews;
        this.identifiers = bldr.identifiers;
        this.typeMap = bldr.overridesTypeMap.orElse(new TypeMap());
        this.enumDataTypeHelper = bldr.enumDataTypeHelper;
        this.metadataRetrievalStrategyMap = new EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy>(bldr.metadataRetrievalStrategyMap);
    }

    public EnumDataTypeHelper getEnumDataTypeHelper() {
        return this.enumDataTypeHelper;
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public MetadataRetrievalStrategy get(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy) {
        Objects.requireNonNull(schemaInfoMetadataRetrievalStrategy, "No schema info metadata retrieval strategy provided");
        return this.metadataRetrievalStrategyMap.get((Object)schemaInfoMetadataRetrievalStrategy);
    }

    public String getIdentifierQuoteString() {
        if (!this.hasOverrideForIdentifierQuoteString()) {
            return "";
        }
        return this.identifierQuoteString;
    }

    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public boolean hasOverrideForIdentifierQuoteString() {
        return !Utility.isBlank(this.identifierQuoteString);
    }

    public boolean hasOverrideForTypeMap() {
        return this.typeMap != null;
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    Map<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy> getMetadataRetrievalStrategyMap() {
        return new EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy>(this.metadataRetrievalStrategyMap);
    }
}

