/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;

public final class SchemaInfoLevel
implements Options {
    private final boolean[] schemaInfoRetrievals;
    private final String tag;

    SchemaInfoLevel(String tag, Map<SchemaInfoRetrieval, Boolean> schemaInfoRetrievalsMap) {
        Objects.requireNonNull(tag, "No tag provided");
        this.tag = tag;
        Objects.requireNonNull(schemaInfoRetrievalsMap, "No schema info retrievals provided");
        SchemaInfoRetrieval[] schemaInfoRetrievalsArray = SchemaInfoRetrieval.values();
        this.schemaInfoRetrievals = new boolean[schemaInfoRetrievalsArray.length];
        for (SchemaInfoRetrieval schemaInfoRetrieval : schemaInfoRetrievalsArray) {
            boolean schemaInfoRetrievalValue;
            this.schemaInfoRetrievals[schemaInfoRetrieval.ordinal()] = schemaInfoRetrievalValue = schemaInfoRetrievalsMap.getOrDefault((Object)schemaInfoRetrieval, false).booleanValue();
        }
    }

    public String getTag() {
        return this.tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.schemaInfoRetrievals);
        result = 31 * result + Objects.hash(this.tag);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaInfoLevel)) {
            return false;
        }
        SchemaInfoLevel other = (SchemaInfoLevel)obj;
        return Arrays.equals(this.schemaInfoRetrievals, other.schemaInfoRetrievals) && Objects.equals(this.tag, other.tag);
    }

    public String toString() {
        StringJoiner settings = new StringJoiner(System.lineSeparator());
        for (SchemaInfoRetrieval schemaInfoRetrieval : SchemaInfoRetrieval.values()) {
            settings.add(String.format("  %s=%b", schemaInfoRetrieval.name(), this.is(schemaInfoRetrieval)));
        }
        return String.format("SchemaInfoLevel <%s>%n{%n%s%n}%n", this.tag, settings);
    }

    public boolean is(SchemaInfoRetrieval schemaInfoRetrieval) {
        if (schemaInfoRetrieval == null) {
            return false;
        }
        return this.schemaInfoRetrievals[schemaInfoRetrieval.ordinal()];
    }
}

