/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.FilterOptionsBuilder;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public final class SchemaCrawlerOptionsBuilder
implements OptionsBuilder<SchemaCrawlerOptionsBuilder, SchemaCrawlerOptions> {
    private LimitOptions limitOptions = LimitOptionsBuilder.newLimitOptions();
    private FilterOptions filterOptions = FilterOptionsBuilder.newFilterOptions();
    private GrepOptions grepOptions = GrepOptionsBuilder.newGrepOptions();
    private LoadOptions loadOptions = LoadOptionsBuilder.newLoadOptions();

    public static SchemaCrawlerOptionsBuilder builder() {
        return new SchemaCrawlerOptionsBuilder();
    }

    public static SchemaCrawlerOptions newSchemaCrawlerOptions() {
        return SchemaCrawlerOptionsBuilder.builder().toOptions();
    }

    private SchemaCrawlerOptionsBuilder() {
    }

    public SchemaCrawlerOptionsBuilder fromOptions(SchemaCrawlerOptions options) {
        if (options == null) {
            return this;
        }
        this.limitOptions = options.getLimitOptions();
        this.filterOptions = options.getFilterOptions();
        this.grepOptions = options.getGrepOptions();
        this.loadOptions = options.getLoadOptions();
        return this;
    }

    @Override
    public SchemaCrawlerOptions toOptions() {
        return new SchemaCrawlerOptions(this.limitOptions, this.filterOptions, this.grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptionsBuilder withGrepOptions(GrepOptions grepOptions) {
        if (grepOptions != null) {
            this.grepOptions = grepOptions;
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withGrepOptionsBuilder(GrepOptionsBuilder grepOptionsBuilder) {
        if (grepOptionsBuilder != null) {
            this.grepOptions = grepOptionsBuilder.toOptions();
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withLoadOptions(LoadOptions loadOptions) {
        if (loadOptions != null) {
            this.loadOptions = loadOptions;
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withLoadOptionsBuilder(LoadOptionsBuilder loadOptionsBuilder) {
        if (loadOptionsBuilder != null) {
            this.loadOptions = loadOptionsBuilder.toOptions();
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withFilterOptions(FilterOptions filterOptions) {
        if (filterOptions != null) {
            this.filterOptions = filterOptions;
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withFilterOptionsBuilder(FilterOptionsBuilder filterOptionsBuilder) {
        if (filterOptionsBuilder != null) {
            this.filterOptions = filterOptionsBuilder.toOptions();
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withLimitOptions(LimitOptions limitOptions) {
        if (limitOptions != null) {
            this.limitOptions = limitOptions;
        }
        return this;
    }

    public SchemaCrawlerOptionsBuilder withLimitOptionsBuilder(LimitOptionsBuilder limitOptionsBuilder) {
        if (limitOptionsBuilder != null) {
            this.limitOptions = limitOptionsBuilder.toOptions();
        }
        return this;
    }

    public LimitOptions getLimitOptions() {
        return this.limitOptions;
    }

    public FilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    public GrepOptions getGrepOptions() {
        return this.grepOptions;
    }

    public LoadOptions getLoadOptions() {
        return this.loadOptions;
    }
}

