/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Optional;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.OptionsBuilder;

public final class GrepOptionsBuilder
implements OptionsBuilder<GrepOptionsBuilder, GrepOptions> {
    private Optional<InclusionRule> grepColumnInclusionRule = Optional.empty();
    private Optional<InclusionRule> grepDefinitionInclusionRule;
    private boolean grepInvertMatch;
    private boolean grepOnlyMatching;
    private Optional<InclusionRule> grepRoutineParameterInclusionRule = Optional.empty();

    public static GrepOptionsBuilder builder() {
        return new GrepOptionsBuilder();
    }

    public static GrepOptions newGrepOptions() {
        return GrepOptionsBuilder.builder().toOptions();
    }

    private GrepOptionsBuilder() {
        this.grepDefinitionInclusionRule = Optional.empty();
    }

    public GrepOptionsBuilder fromOptions(GrepOptions options) {
        if (options == null) {
            return this;
        }
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        this.grepRoutineParameterInclusionRule = Optional.ofNullable(options.getGrepRoutineParameterInclusionRule()).orElse(null);
        this.grepDefinitionInclusionRule = Optional.ofNullable(options.getGrepDefinitionInclusionRule()).orElse(null);
        this.grepInvertMatch = options.isGrepInvertMatch();
        this.grepOnlyMatching = options.isGrepOnlyMatching();
        return this;
    }

    @Override
    public GrepOptions toOptions() {
        GrepOptions grepOptions = new GrepOptions(this.grepColumnInclusionRule.orElse(null), this.grepRoutineParameterInclusionRule.orElse(null), this.grepDefinitionInclusionRule.orElse(null), this.grepInvertMatch, this.grepOnlyMatching);
        return grepOptions;
    }

    public GrepOptionsBuilder grepOnlyMatching(boolean grepOnlyMatching) {
        this.grepOnlyMatching = grepOnlyMatching;
        return this;
    }

    public GrepOptionsBuilder includeGreppedColumns(InclusionRule grepColumnInclusionRule) {
        this.grepColumnInclusionRule = Optional.ofNullable(grepColumnInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedColumns(Pattern grepColumnPattern) {
        this.grepColumnInclusionRule = grepColumnPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepColumnPattern));
        return this;
    }

    public GrepOptionsBuilder includeGreppedDefinitions(InclusionRule grepDefinitionInclusionRule) {
        this.grepDefinitionInclusionRule = Optional.ofNullable(grepDefinitionInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedDefinitions(Pattern grepDefinitionPattern) {
        this.grepDefinitionInclusionRule = grepDefinitionPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepDefinitionPattern));
        return this;
    }

    public GrepOptionsBuilder includeGreppedRoutineParameters(InclusionRule grepRoutineParameterInclusionRule) {
        this.grepRoutineParameterInclusionRule = Optional.ofNullable(grepRoutineParameterInclusionRule);
        return this;
    }

    public GrepOptionsBuilder includeGreppedRoutineParameters(Pattern grepRoutineParametersPattern) {
        this.grepRoutineParameterInclusionRule = grepRoutineParametersPattern == null ? Optional.empty() : Optional.of(new RegularExpressionInclusionRule(grepRoutineParametersPattern));
        return this;
    }

    public GrepOptionsBuilder invertGrepMatch(boolean grepInvertMatch) {
        this.grepInvertMatch = grepInvertMatch;
        return this;
    }
}

