/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.Serializable;
import us.fatehi.utility.Utility;

public final class DatabaseServerType
implements Serializable,
Comparable<DatabaseServerType> {
    private static final long serialVersionUID = 2160456864554076419L;
    public static final DatabaseServerType UNKNOWN = new DatabaseServerType();
    private final String databaseSystemIdentifier;
    private final String databaseSystemName;
    private final String jdbcDriverClassName;

    public DatabaseServerType(String databaseSystemIdentifier, String databaseSystemName, String jdbcDriverClassName) {
        this.databaseSystemIdentifier = Utility.requireNotBlank(databaseSystemIdentifier, "No database system identifier provided");
        this.databaseSystemName = Utility.requireNotBlank(databaseSystemName, "No database system name provided");
        this.jdbcDriverClassName = Utility.isBlank(jdbcDriverClassName) ? null : jdbcDriverClassName;
    }

    public DatabaseServerType(String databaseSystemIdentifier, String databaseSystemName) {
        this(databaseSystemIdentifier, databaseSystemName, null);
    }

    private DatabaseServerType() {
        this.databaseSystemIdentifier = null;
        this.databaseSystemName = null;
        this.jdbcDriverClassName = null;
    }

    @Override
    public int compareTo(DatabaseServerType other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        if (other.isUnknownDatabaseSystem() && !this.isUnknownDatabaseSystem()) {
            return 1;
        }
        if (!other.isUnknownDatabaseSystem() && this.isUnknownDatabaseSystem()) {
            return -1;
        }
        return this.getDatabaseSystemIdentifier().compareTo(other.getDatabaseSystemIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseSystemIdentifier == null ? 0 : this.databaseSystemIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseServerType other = (DatabaseServerType)obj;
        if (this.databaseSystemIdentifier == null) {
            return other.databaseSystemIdentifier == null;
        }
        return this.databaseSystemIdentifier.equals(other.databaseSystemIdentifier);
    }

    public String toString() {
        if (this.isUnknownDatabaseSystem()) {
            return "";
        }
        return String.format("%s - %s", this.databaseSystemIdentifier, this.databaseSystemName);
    }

    public String getDatabaseSystemIdentifier() {
        return this.databaseSystemIdentifier;
    }

    public String getDatabaseSystemName() {
        return this.databaseSystemName;
    }

    public String getJdbcDriverClassName() {
        return this.jdbcDriverClassName;
    }

    public boolean isUnknownDatabaseSystem() {
        return Utility.isBlank(this.databaseSystemIdentifier);
    }
}

