/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schema.TableType;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.Utility;

public final class TableTypes
implements Iterable<TableType> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableTypes.class.getName());
    private final List<TableType> tableTypes;

    public static TableTypes from(Collection<String> tableTypeStrings) {
        if (tableTypeStrings == null) {
            return new TableTypes(null);
        }
        HashSet<TableType> tableTypes = new HashSet<TableType>();
        for (String tableTypeString : tableTypeStrings) {
            if (Utility.isBlank(tableTypeString)) continue;
            tableTypes.add(new TableType(tableTypeString));
        }
        return new TableTypes(tableTypes);
    }

    public static TableTypes from(Connection connection) {
        Objects.requireNonNull(connection, "No connection provided");
        HashSet<TableType> tableTypes = new HashSet<TableType>();
        try (ResultSet tableTypesResults = connection.getMetaData().getTableTypes();){
            List<String> tableTypeStrings = DatabaseUtility.readResultsVector(tableTypesResults);
            for (String tableTypeString : tableTypeStrings) {
                if (Utility.isBlank(tableTypeString)) continue;
                tableTypes.add(new TableType(tableTypeString));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not obtain table types from connection", (Throwable)e);
        }
        return new TableTypes(tableTypes);
    }

    public static TableTypes from(String ... tableTypeStrings) {
        if (tableTypeStrings == null) {
            return new TableTypes(null);
        }
        return TableTypes.from(Arrays.asList(tableTypeStrings));
    }

    public static TableTypes from(String tableTypesString) {
        if (tableTypesString == null) {
            return new TableTypes(null);
        }
        String[] tableTypeStrings = tableTypesString.split(",");
        return TableTypes.from(tableTypeStrings);
    }

    public static TableTypes includeNone() {
        return TableTypes.from("");
    }

    public static TableTypes includeAll() {
        return TableTypes.from((Collection<String>)null);
    }

    private TableTypes(Collection<TableType> tableTypesCollection) {
        if (tableTypesCollection == null) {
            this.tableTypes = null;
        } else {
            this.tableTypes = new ArrayList<TableType>(tableTypesCollection);
            Collections.sort(this.tableTypes);
        }
    }

    public TableTypes subsetFrom(TableTypes tableTypesKeepList) {
        Objects.requireNonNull(tableTypesKeepList, "No keep list of table types provided");
        if (tableTypesKeepList.isIncludeAll()) {
            return this;
        }
        if (tableTypesKeepList.isIncludeNone()) {
            return new TableTypes(null);
        }
        ArrayList<TableType> filteredTableTypes = new ArrayList<TableType>();
        for (TableType tableType : tableTypesKeepList) {
            if (!this.tableTypes.contains(tableType)) continue;
            int index = this.tableTypes.indexOf(tableType);
            filteredTableTypes.add(this.tableTypes.get(index));
        }
        filteredTableTypes.sort(Comparator.naturalOrder());
        return new TableTypes(filteredTableTypes);
    }

    @Override
    public Iterator<TableType> iterator() {
        if (this.isIncludeAll()) {
            throw new IllegalArgumentException("Include all table types, but none are known");
        }
        return this.tableTypes.iterator();
    }

    public Optional<TableType> lookupTableType(String tableTypeString) {
        if (this.isIncludeAll()) {
            return Optional.of(new TableType(tableTypeString));
        }
        for (TableType tableType : this.tableTypes) {
            if (!tableType.isEqualTo(tableTypeString)) continue;
            return Optional.of(tableType);
        }
        return Optional.empty();
    }

    public String toString() {
        if (this.isIncludeAll()) {
            return "<all table types>";
        }
        return this.tableTypes.toString();
    }

    public String[] toArray() {
        if (this.isIncludeAll()) {
            return null;
        }
        return (String[])this.tableTypes.stream().map(tableType -> tableType.getTableType()).toArray(String[]::new);
    }

    public boolean isIncludeNone() {
        return this.tableTypes.isEmpty();
    }

    public boolean isIncludeAll() {
        return this.tableTypes == null;
    }
}

