/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.crawl.MutableFunctionParameter;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionParameter;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;

final class MutableFunction
extends MutableRoutine
implements Function {
    private static final long serialVersionUID = 3906925686089134130L;
    private final NamedObjectList<MutableFunctionParameter> columns = new NamedObjectList();
    private FunctionReturnType returnType = FunctionReturnType.unknown;

    MutableFunction(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return new ArrayList<FunctionParameter>(this.columns.values());
    }

    @Override
    public FunctionReturnType getReturnType() {
        return this.returnType;
    }

    void setReturnType(FunctionReturnType returnType) {
        this.returnType = Objects.requireNonNull(returnType, "Null function return type");
    }

    public Optional<MutableFunctionParameter> lookupParameter(String name) {
        return this.columns.lookup(this, name);
    }

    @Override
    public RoutineType getRoutineType() {
        return RoutineType.function;
    }

    void addParameter(MutableFunctionParameter column) {
        this.columns.add(column);
    }
}

