/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Column;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class IndexRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(IndexRetriever.class.getName());

    IndexRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveIndexes(NamedObjectList<MutableTable> allTables) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.indexesRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving indexes, using fast data dictionary retrieval");
                this.retrieveIndexesFromDataDictionary(allTables);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving indexes");
                this.retrieveIndexesFromMetadata(allTables);
                break;
            }
        }
    }

    private void createIndexes(MutableTable table, MetadataResultSet results) throws SQLException {
        while (results.next()) {
            this.createIndexForTable(table, results);
        }
    }

    private void createIndexForTable(MutableTable table, MetadataResultSet results) {
        MutableIndex index;
        Optional<MutableIndex> indexOptional;
        AbstractDependantObject column;
        String indexName = results.getString("INDEX_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving index <%s.%s>", table, indexName));
        String columnName = results.getString("COLUMN_NAME");
        if (Utility.isBlank(columnName)) {
            return;
        }
        LOGGER.log(Level.FINE, new StringFormat("Retrieving index column <%s.%s.%s>", table, indexName, columnName));
        boolean uniqueIndex = !results.getBoolean("NON_UNIQUE");
        IndexType type = results.getEnumFromId("TYPE", IndexType.unknown);
        int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
        IndexColumnSortSequence sortSequence = IndexColumnSortSequence.valueOfFromCode(results.getString("ASC_OR_DESC"));
        int cardinality = results.getInt("CARDINALITY", 0);
        int pages = results.getInt("PAGES", 0);
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        if (columnOptional.isPresent()) {
            MutableColumn mutableColumn = columnOptional.get();
            mutableColumn.markAsPartOfIndex();
            if (uniqueIndex) {
                mutableColumn.markAsPartOfUniqueIndex();
            }
            column = mutableColumn;
        } else {
            column = new ColumnPartial(table, columnName);
        }
        if (Utility.isBlank(indexName)) {
            indexName = String.format("SC_%s", Integer.toHexString(column.getFullName().hashCode()).toUpperCase());
        }
        if ((indexOptional = table.lookupIndex(indexName)).isPresent()) {
            index = indexOptional.get();
        } else {
            index = new MutableIndex(table, indexName);
            table.addIndex(index);
        }
        MutableIndexColumn indexColumn = new MutableIndexColumn(index, (Column)((Object)column));
        indexColumn.setKeyOrdinalPosition(ordinalPosition);
        indexColumn.setSortSequence(sortSequence);
        index.addColumn(indexColumn);
        index.setUnique(uniqueIndex);
        index.setIndexType(type);
        index.setCardinality(cardinality);
        index.setPages(pages);
        index.addAttributes(results.getAttributes());
    }

    private void retrieveIndexesFromDataDictionary(NamedObjectList<MutableTable> allTables) throws SchemaCrawlerSQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.INDEXES)) {
            LOGGER.log(Level.FINE, "Extended indexes SQL statement was not provided");
            return;
        }
        Query indexesSql = informationSchemaViews.getQuery(InformationSchemaKey.INDEXES);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(indexesSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveIndexesFromDataDictionary");
            while (results.next()) {
                String tableName;
                String schemaName;
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
                Optional<MutableTable> optionalTable = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM")), tableName = results.getString("TABLE_NAME"));
                if (!optionalTable.isPresent()) continue;
                MutableTable table = optionalTable.get();
                this.createIndexForTable(table, results);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indexes from SQL:\n" + indexesSql, e);
        }
    }

    private void retrieveTableIndexesFromMetadata(MutableTable table, boolean unique) throws SQLException {
        Schema tableSchema = table.getSchema();
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getIndexInfo(tableSchema.getCatalogName(), tableSchema.getName(), table.getName(), unique, true));){
            this.createIndexes(table, results);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve indexes for table " + table, e);
        }
    }

    private void retrieveIndexesFromMetadata(NamedObjectList<MutableTable> allTables) throws SQLException {
        for (MutableTable table : allTables) {
            this.retrieveTableIndexesFromMetadata(table, false);
            this.retrieveTableIndexesFromMetadata(table, true);
        }
    }
}

