/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import schemacrawler.crawl.AbstractProperty;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.Property;
import us.fatehi.utility.Utility;

final class ImmutableJdbcDriverProperty
extends AbstractProperty
implements JdbcDriverProperty {
    private static final long serialVersionUID = 8030156654422512161L;
    private final List<String> choices;
    private final String description;
    private final boolean required;

    ImmutableJdbcDriverProperty(DriverPropertyInfo driverPropertyInfo) {
        super(driverPropertyInfo.name, (Serializable)((Object)driverPropertyInfo.value));
        this.description = driverPropertyInfo.description;
        this.required = driverPropertyInfo.required;
        if (driverPropertyInfo.choices == null) {
            this.choices = Collections.emptyList();
        } else {
            this.choices = Arrays.asList(driverPropertyInfo.choices);
            this.choices.sort(Comparator.naturalOrder());
        }
    }

    @Override
    public int compareTo(Property otherProperty) {
        if (otherProperty == null) {
            return -1;
        }
        return this.getName().compareToIgnoreCase(otherProperty.getName());
    }

    @Override
    public Collection<String> getChoices() {
        return new ArrayList<String>(this.choices);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "";
    }

    @Override
    public String getValue() {
        return (String)((Object)super.getValue());
    }

    public boolean hasDescription() {
        return !Utility.isBlank(this.getDescription());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("%s = %s%n", this.getName(), this.getValue()));
        if (this.hasDescription()) {
            buffer.append(this.getDescription()).append(String.format("%n", new Object[0]));
        }
        buffer.append(String.format("  is required? %b%n  choices: %s", this.isRequired(), this.getChoices()));
        return buffer.toString();
    }
}

