/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.associations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import schemacrawler.schema.Column;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;

final class TableCandidateKeys
implements Iterable<Column> {
    private final Table table;
    private final Set<Column> tableKeys;

    TableCandidateKeys(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
        this.tableKeys = new HashSet<Column>();
        this.listTableKeys(table);
    }

    @Override
    public Iterator<Column> iterator() {
        return this.tableKeys.iterator();
    }

    public String toString() {
        return String.format("%s: %s", this.table, this.tableKeys);
    }

    private Set<Column> listTableKeys(Table table) {
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null && primaryKey.getColumns().size() == 1) {
            this.addColumnFromPrimaryKey(table, primaryKey);
        }
        for (Index index : table.getIndexes()) {
            if (index == null || !index.isUnique() || index.getColumns().size() != 1) continue;
            this.addColumnFromIndex(table, index);
        }
        return this.tableKeys;
    }

    private void addColumnFromIndex(Table table, Index index) {
        IndexColumn indexColumn = index.getColumns().get(0);
        table.lookupColumn(indexColumn.getName()).ifPresent(column -> this.tableKeys.add((Column)column));
    }

    private void addColumnFromPrimaryKey(Table table, PrimaryKey primaryKey) {
        TableConstraintColumn tableConstraintColumn = primaryKey.getColumns().get(0);
        table.lookupColumn(tableConstraintColumn.getName()).ifPresent(column -> this.tableKeys.add((Column)column));
    }
}

