/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.associations;

import java.util.AbstractMap;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;

public final class ProposedWeakAssociation
extends AbstractMap.SimpleImmutableEntry<Column, Column> {
    ProposedWeakAssociation(Column key, Column value) {
        super(key, value);
    }

    ProposedWeakAssociation(ColumnReference columnReference) {
        super(columnReference.getPrimaryKeyColumn(), columnReference.getForeignKeyColumn());
    }

    public boolean isValid() {
        Column primaryKeyColumn = (Column)this.getKey();
        Column foreignKeyColumn = (Column)this.getValue();
        Table pkTable = (Table)primaryKeyColumn.getParent();
        Table fkTable = (Table)foreignKeyColumn.getParent();
        if ((foreignKeyColumn.isPartOfPrimaryKey() || foreignKeyColumn.isPartOfUniqueIndex()) && pkTable.compareTo(fkTable) > 0) {
            return false;
        }
        ColumnDataType fkColumnType = foreignKeyColumn.getColumnDataType();
        ColumnDataType pkColumnType = primaryKeyColumn.getColumnDataType();
        boolean isValid = fkColumnType.getJavaSqlType().getName().equals(pkColumnType.getJavaSqlType().getName());
        return isValid;
    }
}

