/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Map;
import java.util.Objects;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.text.base.BaseTextOptions;

public abstract class BaseTextOptionsBuilder<O extends BaseTextOptions>
implements OptionsBuilder<BaseTextOptions> {
    protected static final String SCHEMACRAWLER_FORMAT_PREFIX = "schemacrawler.format.";
    private static final String NO_HEADER = "schemacrawler.format.no_header";
    private static final String NO_FOOTER = "schemacrawler.format.no_footer";
    private static final String NO_INFO = "schemacrawler.format.no_info";
    private static final String APPEND_OUTPUT = "schemacrawler.format.append_output";
    private static final String SHOW_UNQUALIFIED_NAMES = "schemacrawler.format.show_unqualified_names";
    private static final String SORT_ALPHABETICALLY_TABLES = "schemacrawler.format.sort_alphabetically.tables";
    private static final String SORT_ALPHABETICALLY_TABLE_COLUMNS = "schemacrawler.format.sort_alphabetically.table_columns";
    private static final String SORT_ALPHABETICALLY_ROUTINES = "schemacrawler.format.sort_alphabetically.routines";
    private static final String SORT_ALPHABETICALLY_ROUTINE_COLUMNS = "schemacrawler.format.sort_alphabetically.routine_columns";
    private static final String NO_SCHEMA_COLORS = "schemacrawler.format.no_schema_colors";
    protected final O options;

    protected BaseTextOptionsBuilder(O options) {
        this.options = (BaseTextOptions)Objects.requireNonNull(options);
    }

    public BaseTextOptionsBuilder<O> appendOutput() {
        ((BaseTextOptions)this.options).setAppendOutput(true);
        return this;
    }

    public BaseTextOptionsBuilder<O> fromConfig(Config map) {
        if (map == null) {
            return this;
        }
        Config config = new Config((Map)map);
        ((BaseTextOptions)this.options).setNoFooter(config.getBooleanValue(NO_FOOTER));
        ((BaseTextOptions)this.options).setNoHeader(config.getBooleanValue(NO_HEADER));
        ((BaseTextOptions)this.options).setNoInfo(config.getBooleanValue(NO_INFO));
        ((BaseTextOptions)this.options).setAppendOutput(config.getBooleanValue(APPEND_OUTPUT));
        ((BaseTextOptions)this.options).setShowUnqualifiedNames(config.getBooleanValue(SHOW_UNQUALIFIED_NAMES));
        ((BaseTextOptions)this.options).setAlphabeticalSortForTables(config.getBooleanValue(SORT_ALPHABETICALLY_TABLES, ((BaseTextOptions)this.options).isAlphabeticalSortForTables()));
        ((BaseTextOptions)this.options).setAlphabeticalSortForTableColumns(config.getBooleanValue(SORT_ALPHABETICALLY_TABLE_COLUMNS, ((BaseTextOptions)this.options).isAlphabeticalSortForTableColumns()));
        ((BaseTextOptions)this.options).setAlphabeticalSortForRoutines(config.getBooleanValue(SORT_ALPHABETICALLY_ROUTINES, ((BaseTextOptions)this.options).isAlphabeticalSortForRoutines()));
        ((BaseTextOptions)this.options).setAlphabeticalSortForRoutineColumns(config.getBooleanValue(SORT_ALPHABETICALLY_ROUTINE_COLUMNS, ((BaseTextOptions)this.options).isAlphabeticalSortForRoutineColumns()));
        ((BaseTextOptions)this.options).setNoSchemaColors(config.getBooleanValue(NO_SCHEMA_COLORS));
        return this;
    }

    public BaseTextOptionsBuilder<O> noFooter(boolean value) {
        ((BaseTextOptions)this.options).setNoFooter(value);
        return this;
    }

    public BaseTextOptionsBuilder<O> noHeader(boolean value) {
        ((BaseTextOptions)this.options).setNoHeader(value);
        return this;
    }

    public BaseTextOptionsBuilder<O> noInfo(boolean value) {
        ((BaseTextOptions)this.options).setNoInfo(value);
        return this;
    }

    public BaseTextOptionsBuilder<O> overwriteOutput() {
        ((BaseTextOptions)this.options).setAppendOutput(false);
        return this;
    }

    public BaseTextOptionsBuilder<O> sortTableColumns(boolean value) {
        ((BaseTextOptions)this.options).setAlphabeticalSortForTableColumns(value);
        return this;
    }

    public BaseTextOptionsBuilder<O> sortTables(boolean value) {
        ((BaseTextOptions)this.options).setAlphabeticalSortForTables(value);
        return this;
    }

    public Config toConfig() {
        Config config = new Config();
        config.setBooleanValue(NO_FOOTER, ((BaseTextOptions)this.options).isNoFooter());
        config.setBooleanValue(NO_HEADER, ((BaseTextOptions)this.options).isNoHeader());
        config.setBooleanValue(NO_INFO, ((BaseTextOptions)this.options).isNoInfo());
        config.setBooleanValue(APPEND_OUTPUT, ((BaseTextOptions)this.options).isAppendOutput());
        config.setBooleanValue(SHOW_UNQUALIFIED_NAMES, ((BaseTextOptions)this.options).isShowUnqualifiedNames());
        config.setBooleanValue(SORT_ALPHABETICALLY_TABLES, ((BaseTextOptions)this.options).isAlphabeticalSortForTables());
        config.setBooleanValue(SORT_ALPHABETICALLY_TABLE_COLUMNS, ((BaseTextOptions)this.options).isAlphabeticalSortForTableColumns());
        config.setBooleanValue(SORT_ALPHABETICALLY_ROUTINES, ((BaseTextOptions)this.options).isAlphabeticalSortForRoutines());
        config.setBooleanValue(SORT_ALPHABETICALLY_ROUTINE_COLUMNS, ((BaseTextOptions)this.options).isAlphabeticalSortForRoutineColumns());
        config.setBooleanValue(NO_SCHEMA_COLORS, ((BaseTextOptions)this.options).isNoSchemaColors());
        return config;
    }

    public O toOptions() {
        return this.options;
    }

    public String toString() {
        return this.options.toString();
    }
}

