/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Collection;
import org.threeten.bp.temporal.TemporalAccessor;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.text.utility.html.Alignment;
import sf.util.ObjectToString;
import sf.util.Utility;

public abstract class BaseTabularFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected BaseTabularFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() {
        if (!this.options.isNoHeader()) {
            this.formattingHelper.writeDocumentStart();
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (!this.options.isNoFooter()) {
            this.formattingHelper.writeDocumentEnd();
        }
        super.end();
    }

    @Override
    public void handle(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        String title = crawlInfo.getTitle();
        if (!Utility.isBlank((CharSequence)title)) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.title, title);
        }
        if (this.options.isNoInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("generated by", crawlInfo.getSchemaCrawlerInfo(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("generated on", this.formatTimestamp((TemporalAccessor)crawlInfo.getCrawlTimestamp()), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database version", crawlInfo.getDatabaseInfo(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver version", crawlInfo.getJdbcDriverInfo(), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public final void handle(DatabaseInfo dbInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || dbInfo == null) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("database product name", dbInfo.getProductName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database product version", dbInfo.getProductVersion(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database user name", dbInfo.getUserName(), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
        if (dbInfo.getProperties().size() > 0) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Characteristics");
            this.formattingHelper.writeObjectStart();
            for (DatabaseProperty property : dbInfo.getProperties()) {
                String name = property.getDescription();
                Object value = property.getValue();
                if (value == null) {
                    value = "";
                }
                this.formattingHelper.writeNameValueRow(name, ObjectToString.toString((Object)value), Alignment.inherit);
            }
            this.formattingHelper.writeObjectEnd();
        }
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || driverInfo == null) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("driver name", driverInfo.getDriverName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver version", driverInfo.getDriverVersion(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver class name", driverInfo.getDriverClassName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("url", driverInfo.getConnectionUrl(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("is JDBC compliant", Boolean.toString(driverInfo.isJdbcCompliant()), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
        Collection jdbcDriverProperties = driverInfo.getDriverProperties();
        if (jdbcDriverProperties.size() > 0) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Properties");
            for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                this.formattingHelper.writeObjectStart();
                this.printJdbcDriverProperty(driverProperty);
                this.formattingHelper.writeObjectEnd();
            }
        }
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "SchemaCrawler Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("product name", schemaCrawlerInfo.getSchemaCrawlerProductName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("product version", schemaCrawlerInfo.getSchemaCrawlerVersion(), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public final void handleHeaderEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleHeaderStart() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoStart() throws SchemaCrawlerException {
        if (!this.printVerboseDatabaseInfo || this.options.isNoInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
    }

    private void printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        String required;
        String details = required = (driverProperty.isRequired() ? "" : "not ") + "required";
        if (driverProperty.getChoices() != null && driverProperty.getChoices().size() > 0) {
            details = details + "; choices " + driverProperty.getChoices();
        }
        String value = driverProperty.getValue();
        this.formattingHelper.writeNameRow(driverProperty.getName(), "[driver property]");
        this.formattingHelper.writeDescriptionRow(driverProperty.getDescription());
        this.formattingHelper.writeDescriptionRow(details);
        this.formattingHelper.writeDetailRow("", "value", value);
    }
}

