/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import org.threeten.bp.temporal.TemporalAccessor;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.tools.text.utility.html.Alignment;
import schemacrawler.tools.text.utility.html.TableCell;
import schemacrawler.tools.text.utility.html.TableRow;
import sf.util.Color;
import sf.util.IOUtility;
import sf.util.Utility;

public abstract class BaseDotFormatter<O extends BaseTextOptions>
extends BaseFormatter<O> {
    protected BaseDotFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() {
        String text = IOUtility.readResourceFully((String)"/dot.header.txt");
        this.formattingHelper.append(text).println();
    }

    @Override
    public void end() throws SchemaCrawlerException {
        this.formattingHelper.append("}").println();
        super.end();
    }

    @Override
    public void handle(CrawlInfo crawlInfo) {
        TableRow row;
        if (this.options.isNoInfo() || crawlInfo == null) {
            return;
        }
        String title = crawlInfo.getTitle();
        if (!Utility.isBlank((CharSequence)title)) {
            row = new TableRow(TextOutputFormat.html);
            row.add(this.newTableCell(title, Alignment.left, true, Color.white, 2));
            this.formattingHelper.append(row.toString()).println();
        }
        row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("generated by", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(crawlInfo.getSchemaCrawlerInfo(), Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(row.toString()).println();
        row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("generated on", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(this.formatTimestamp((TemporalAccessor)crawlInfo.getCrawlTimestamp()), Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(row.toString()).println();
        row = new TableRow(TextOutputFormat.html);
        row.add(this.newTableCell("database version", Alignment.right, false, Color.white, 1));
        row.add(this.newTableCell(crawlInfo.getDatabaseInfo(), Alignment.left, false, Color.white, 1));
        this.formattingHelper.append(row.toString()).println();
    }

    @Override
    public void handle(DatabaseInfo dbInfo) {
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
    }

    @Override
    public void handleHeaderEnd() throws SchemaCrawlerException {
        if (this.options.isNoInfo()) {
            return;
        }
        this.formattingHelper.append("      </table>    >").println();
        this.formattingHelper.append("    labeljust=r").println();
        this.formattingHelper.append("    labelloc=b").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
    }

    @Override
    public void handleHeaderStart() throws SchemaCrawlerException {
        if (this.options.isNoInfo()) {
            return;
        }
        this.formattingHelper.append("  graph [fontcolor=\"#888888\", ").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("<table color=\"#888888\" border=\"1\" cellborder=\"0\" cellspacing=\"0\">").println();
    }

    @Override
    public void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleInfoStart() throws SchemaCrawlerException {
    }

    protected TableCell newTableCell(String text, Alignment align, boolean emphasizeText, Color bgColor, int colspan) {
        return new TableCell(text, true, 0, align, emphasizeText, "", bgColor, colspan, TextOutputFormat.html);
    }
}

