/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import com.annimon.stream.function.Supplier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public class GraphOptionsBuilder
extends SchemaTextOptionsBuilder {
    private static final String GRAPH_SHOW_PRIMARY_KEY_CARDINALITY = "schemacrawler.graph.show.primarykey.cardinality";
    private static final String GRAPH_SHOW_FOREIGN_KEY_CARDINALITY = "schemacrawler.graph.show.foreignkey.cardinality";
    private static final String GRAPH_GRAPHVIZ_OPTS = "schemacrawler.graph.graphviz_opts";
    private static final String SC_GRAPHVIZ_OPTS = "SC_GRAPHVIZ_OPTS";
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)GraphOptions.class.getName());

    public GraphOptionsBuilder() {
        this(new GraphOptions());
    }

    public GraphOptionsBuilder(GraphOptions options) {
        super(options);
    }

    @Override
    public GraphOptionsBuilder fromConfig(Config map) {
        if (map == null) {
            return this;
        }
        super.fromConfig(map);
        Config config = new Config((Map)map);
        GraphOptions options = (GraphOptions)this.options;
        options.setShowPrimaryKeyCardinality(config.getBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, true));
        options.setShowForeignKeyCardinality(config.getBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, true));
        options.setGraphvizOpts(this.listGraphvizOpts(this.readGraphvizOpts(config)));
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        GraphOptions options = (GraphOptions)this.options;
        config.setBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, options.isShowPrimaryKeyCardinality());
        config.setBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, options.isShowForeignKeyCardinality());
        config.setStringValue(GRAPH_GRAPHVIZ_OPTS, Utility.join(options.getGraphvizOpts(), (String)" "));
        return config;
    }

    @Override
    public GraphOptions toOptions() {
        return (GraphOptions)super.toOptions();
    }

    private List<String> listGraphvizOpts(String graphVizOptions) {
        List<String> graphVizOptionsList = Arrays.asList(graphVizOptions.split("\\s+"));
        return graphVizOptionsList;
    }

    private String readGraphvizOpts(Config config) {
        String scGraphvizOptsCfg = config.getStringValue(GRAPH_GRAPHVIZ_OPTS, "");
        if (!Utility.isBlank((CharSequence)scGraphvizOptsCfg)) {
            LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Using additional Graphviz command-line options from config <%s>", new Object[]{scGraphvizOptsCfg}));
            return scGraphvizOptsCfg;
        }
        String scGraphvizOptsProp = System.getProperty(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank((CharSequence)scGraphvizOptsProp)) {
            LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Using additional Graphviz command-line options from SC_GRAPHVIZ_OPTS system property <%s>", new Object[]{scGraphvizOptsProp}));
            return scGraphvizOptsProp;
        }
        String scGraphvizOptsEnv = System.getenv(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank((CharSequence)scGraphvizOptsEnv)) {
            LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Using additional Graphviz command-line options from SC_GRAPHVIZ_OPTS environmental variable <%s>", new Object[]{scGraphvizOptsEnv}));
            return scGraphvizOptsEnv;
        }
        return "";
    }
}

