/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.nio.file.Path;
import java.sql.Connection;
import java.util.Comparator;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.NamedObject;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.analysis.counts.CatalogWithCounts;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.integration.graph.GraphOptionsBuilder;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphProcessExecutor;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;
import sf.util.IOUtility;

public final class GraphExecutable
extends BaseStagedExecutable {
    private GraphOptions graphOptions;

    public GraphExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog db, Connection connection) throws Exception {
        this.loadGraphOptions();
        Object catalog = db;
        if (this.graphOptions.isShowWeakAssociations()) {
            catalog = new CatalogWithAssociations((Catalog)catalog);
        }
        if (this.graphOptions.isShowRowCounts() || this.schemaCrawlerOptions.isHideEmptyTables()) {
            catalog = new CatalogWithCounts((Catalog)catalog, connection, this.schemaCrawlerOptions);
        }
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
        this.outputOptions.setOutputFormatValue(graphOutputFormat.getFormat());
        Path dotFile = IOUtility.createTempFilePath((String)"schemacrawler.", (String)"dot");
        OutputOptions dotFileOutputOptions = graphOutputFormat == GraphOutputFormat.scdot ? this.outputOptions : new OutputOptions((OutputFormat)GraphOutputFormat.dot, dotFile);
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFileOutputOptions);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog((Catalog)catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator((Comparator<NamedObject>)NamedObjectSort.getNamedObjectSort((boolean)this.getGraphOptions().isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator((Comparator<NamedObject>)NamedObjectSort.getNamedObjectSort((boolean)this.getGraphOptions().isAlphabeticalSortForRoutines()));
        traverser.traverse();
        if (graphOutputFormat != GraphOutputFormat.scdot) {
            GraphOptions graphOptions = this.getGraphOptions();
            GraphProcessExecutor graphProcessExecutor = new GraphProcessExecutor(dotFile, this.outputOptions.getOutputFile(), graphOptions, graphOutputFormat);
            graphProcessExecutor.call();
        }
    }

    public final GraphOptions getGraphOptions() {
        this.loadGraphOptions();
        return this.graphOptions;
    }

    public final void setGraphOptions(GraphOptions graphOptions) {
        this.graphOptions = graphOptions;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(OutputOptions outputOptions) throws SchemaCrawlerException {
        GraphOptions graphOptions = this.getGraphOptions();
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, graphOptions, outputOptions);
        return formatter;
    }

    private void loadGraphOptions() {
        if (this.graphOptions == null) {
            this.graphOptions = new GraphOptionsBuilder().fromConfig(this.additionalConfiguration).toOptions();
        }
    }
}

