/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import com.annimon.stream.function.Supplier;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

abstract class ExecutableCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)ExecutableCommandProvider.class.getName());
    private final String command;
    private final String executableClassName;

    ExecutableCommandProvider(String command, String executableClassName) {
        this.command = command;
        this.executableClassName = executableClassName;
    }

    @Override
    public Executable configureNewExecutable(SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) throws SchemaCrawlerException {
        Executable executable;
        Class<?> commandExecutableClass;
        try {
            commandExecutableClass = Class.forName(this.executableClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load class " + this.executableClassName, (Throwable)e);
        }
        try {
            executable = (Executable)commandExecutableClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, (Supplier)new StringFormat("Could not instantiate using default constructor for class <%s>", new Object[]{this.executableClassName}));
            try {
                Constructor<?> constructor = commandExecutableClass.getConstructor(String.class);
                executable = (Executable)constructor.newInstance(this.command);
            }
            catch (Exception e1) {
                throw new SchemaCrawlerException("Could not instantiate executable for command '" + this.command + "'", (Throwable)e1);
            }
        }
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setOutputOptions(outputOptions);
        return executable;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getHelpAdditionalText() {
        return "";
    }

    @Override
    public String getHelpResource() {
        String helpResource = "/help/DefaultExecutable.txt";
        return "/help/DefaultExecutable.txt";
    }

    public String toString() {
        return this.executableClassName;
    }
}

