/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseCommandChainExecutable;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;

public final class CommandChainExecutable
extends BaseCommandChainExecutable {
    private static final String COMMAND = "chain";

    public CommandChainExecutable() throws SchemaCrawlerException {
        super(COMMAND);
    }

    public final Executable addNext(String command, OutputFormat outputFormat, Path outputFile) throws SchemaCrawlerException {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFile, "No output file provided");
        return this.addNext(command, outputFormat.getFormat(), outputFile.normalize().toAbsolutePath().toString());
    }

    public final Executable addNext(String command, String outputFormat, String outputFileName) throws SchemaCrawlerException {
        try {
            OutputOptions outputOptions = new OutputOptions(outputFormat, Paths.get(outputFileName, new String[0]));
            Executable executable = this.commandRegistry.configureNewExecutable(command, this.schemaCrawlerOptions, outputOptions);
            if (executable == null) {
                return null;
            }
            executable.setAdditionalConfiguration(this.additionalConfiguration);
            return this.addNext(executable);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain executable, unknown command, %s - %s - %s", command, outputFormat, outputFileName));
        }
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        this.executeChain(catalog, connection);
    }
}

