/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import com.annimon.stream.function.Supplier;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class DatabaseConnectorRegistry
implements Iterable<String> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)DatabaseConnectorRegistry.class.getName());
    private final Map<String, DatabaseConnector> databaseConnectorRegistry = DatabaseConnectorRegistry.loadDatabaseConnectorRegistry();

    private static Map<String, DatabaseConnector> loadDatabaseConnectorRegistry() throws SchemaCrawlerException {
        HashMap<String, DatabaseConnector> databaseConnectorRegistry = new HashMap<String, DatabaseConnector>();
        try {
            ServiceLoader<DatabaseConnector> serviceLoader = ServiceLoader.load(DatabaseConnector.class);
            for (DatabaseConnector databaseConnector : serviceLoader) {
                String databaseSystemIdentifier = databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier();
                try {
                    LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Loading database connector, %s=%s", new Object[]{databaseSystemIdentifier, databaseConnector.getClass().getName()}));
                    databaseConnector.checkDatabaseConnectionOptions();
                    databaseConnectorRegistry.put(databaseSystemIdentifier, databaseConnector);
                }
                catch (Exception e) {
                    LOGGER.log(Level.CONFIG, (Supplier)new StringFormat("Could not load database connector, %s=%s", new Object[]{databaseSystemIdentifier, databaseConnector.getClass().getName()}), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load database connector registry", (Throwable)e);
        }
        return databaseConnectorRegistry;
    }

    public DatabaseConnectorRegistry() throws SchemaCrawlerException {
        this.logRegisteredJdbcDrivers();
    }

    public boolean hasDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        return this.databaseConnectorRegistry.containsKey(databaseSystemIdentifier);
    }

    @Override
    public Iterator<String> iterator() {
        return this.lookupAvailableDatabaseConnectors().iterator();
    }

    public DatabaseConnector lookupDatabaseConnector(Connection connection) {
        try {
            DatabaseUtility.checkConnection((Connection)connection);
            String url = connection.getMetaData().getURL();
            return this.lookupDatabaseConnectorFromUrl(url);
        }
        catch (SQLException | SchemaCrawlerException e) {
            return DatabaseConnector.UNKNOWN;
        }
    }

    public DatabaseConnector lookupDatabaseConnector(String databaseSystemIdentifier) {
        if (this.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
            return this.databaseConnectorRegistry.get(databaseSystemIdentifier);
        }
        return DatabaseConnector.UNKNOWN;
    }

    public DatabaseConnector lookupDatabaseConnectorFromUrl(String url) {
        if (Utility.isBlank((CharSequence)url)) {
            return DatabaseConnector.UNKNOWN;
        }
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            Pattern connectionUrlPattern = databaseConnector.getConnectionUrlPattern();
            if (connectionUrlPattern == null || !connectionUrlPattern.matcher(url).matches()) continue;
            return databaseConnector;
        }
        return DatabaseConnector.UNKNOWN;
    }

    private void logRegisteredJdbcDrivers() {
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        try {
            StringBuilder buffer = new StringBuilder(1024);
            buffer.append("Registered JDBC drivers:");
            for (Driver driver : Collections.list(DriverManager.getDrivers())) {
                buffer.append(String.format("%n%s %d.%d", driver.getClass().getName(), driver.getMajorVersion(), driver.getMinorVersion()));
            }
            LOGGER.log(Level.CONFIG, buffer.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not log registered JDBC drivers", (Throwable)e);
        }
    }

    private Collection<String> lookupAvailableDatabaseConnectors() {
        ArrayList<String> availableDatabaseConnectors = new ArrayList<String>(this.databaseConnectorRegistry.keySet());
        Collections.sort(availableDatabaseConnectors);
        return availableDatabaseConnectors;
    }
}

