/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.counts;

import com.annimon.stream.Optional;
import com.annimon.stream.function.Predicate;
import com.annimon.stream.function.Supplier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import schemacrawler.crawl.TablesReducer;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.BaseCatalogDecorator;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.analysis.counts.CountsUtility;
import schemacrawler.tools.analysis.counts.TableCountFilter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.utility.Query;
import schemacrawler.utility.QueryUtility;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CatalogWithCounts
extends BaseCatalogDecorator {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)CatalogWithCounts.class.getName());
    private static final long serialVersionUID = -3953296149824921463L;
    private final Map<Table, Long> counts = new HashMap<Table, Long>();

    public CatalogWithCounts(Catalog catalog, Connection connection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        super(catalog);
        try {
            DatabaseUtility.checkConnection((Connection)connection);
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.WARNING, "No connection provided", (Throwable)e);
            return;
        }
        Query query = Operation.count.getQuery();
        ArrayList allTables = new ArrayList(catalog.getTables());
        for (Table table : allTables) {
            try {
                long count = QueryUtility.executeForLong((Query)query, (Connection)connection, (Table)table);
                this.counts.put(table, count);
                CountsUtility.addRowCountToTable(table, count);
            }
            catch (SchemaCrawlerException e) {
                LOGGER.log(Level.WARNING, (Supplier)new StringFormat("Could not get count for table <%s>", new Object[]{table}), (Throwable)e);
            }
        }
        this.reduce(Table.class, (Reducer)new TablesReducer(options, (Predicate)new TableCountFilter(options)));
    }

    public final <T> T getAttribute(String name) {
        return (T)this.getAttribute(name, null);
    }

    public Map<Table, Long> getCounts() {
        return this.counts;
    }

    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }
}

