/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import us.codecraft.xsoup.DefaultXElement;
import us.codecraft.xsoup.ElementOperator;
import us.codecraft.xsoup.XElement;
import us.codecraft.xsoup.XElements;

public class DefaultXElements
extends ArrayList<XElement>
implements XElements {
    private Elements elements;
    private ElementOperator elementOperator;

    public DefaultXElements(Elements elements, ElementOperator elementOperator) {
        this.elements = elements;
        this.elementOperator = elementOperator;
        this.initList();
    }

    private void initList() {
        for (Element element : this.elements) {
            this.add(new DefaultXElement(element, this.elementOperator));
        }
    }

    @Override
    public String get() {
        if (this.size() < 1) {
            return null;
        }
        return ((XElement)this.get(0)).get();
    }

    @Override
    public List<String> list() {
        ArrayList<String> resultStrings = new ArrayList<String>();
        for (XElement xElement : this) {
            String text = xElement.get();
            if (text == null) continue;
            resultStrings.add(text);
        }
        return resultStrings;
    }

    @Override
    public String toString() {
        return this.get();
    }

    @Override
    public Elements getElements() {
        return this.elements;
    }
}

