/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.utils;

import java.util.Map;
import us.codecraft.webmagic.utils.MultiKeyMapBase;

public class DoubleKeyMap<K1, K2, V>
extends MultiKeyMapBase {
    private Map<K1, Map<K2, V>> map;

    public DoubleKeyMap() {
        this.init();
    }

    public DoubleKeyMap(Map<K1, Map<K2, V>> map) {
        this(map, DEFAULT_CLAZZ);
    }

    public DoubleKeyMap(Class<? extends Map> protoMapClass) {
        super(protoMapClass);
        this.init();
    }

    private void init() {
        if (this.map == null) {
            this.map = this.newMap();
        }
    }

    public DoubleKeyMap(Map<K1, Map<K2, V>> map, Class<? extends Map> protoMapClass) {
        super(protoMapClass);
        this.map = map;
        this.init();
    }

    public Map<K2, V> get(K1 key) {
        return this.map.get(key);
    }

    public V get(K1 key1, K2 key2) {
        if (this.get(key1) == null) {
            return null;
        }
        return this.get(key1).get(key2);
    }

    public V put(K1 key1, Map<K2, V> submap) {
        return this.put(key1, submap);
    }

    public synchronized V put(K1 key1, K2 key2, V value) {
        if (this.map.get(key1) == null) {
            this.map.put(key1, this.newMap());
        }
        return this.get(key1).put(key2, value);
    }

    public synchronized V remove(K1 key1, K2 key2) {
        if (this.get(key1) == null) {
            return null;
        }
        V remove = this.get(key1).remove(key2);
        if (this.get(key1).size() == 0) {
            this.remove(key1);
        }
        return remove;
    }

    public Map<K2, V> remove(K1 key1) {
        Map<K2, V> remove = this.map.remove(key1);
        return remove;
    }
}

