/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.example;

import org.apache.log4j.Logger;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.handler.CompositePageProcessor;
import us.codecraft.webmagic.handler.CompositePipeline;
import us.codecraft.webmagic.handler.PatternProcessor;
import us.codecraft.webmagic.handler.RequestMatcher;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

public class PatternProcessorExample {
    private static Logger log = Logger.getLogger(PatternProcessorExample.class);

    public static void main(String ... args) {
        PatternProcessor githubRepoProcessor = new PatternProcessor("https://github\\.com/[\\w\\-]+/[\\w\\-]+"){

            @Override
            public RequestMatcher.MatchOther processPage(Page page) {
                page.putField("reponame", (Object)page.getHtml().xpath("//h1[@class='entry-title public']/strong/a/text()").toString());
                return RequestMatcher.MatchOther.YES;
            }

            @Override
            public RequestMatcher.MatchOther processResult(ResultItems resultItems, Task task) {
                log.info((Object)("Extracting from repo" + resultItems.getRequest()));
                System.out.println("Repo name: " + resultItems.get("reponame"));
                return RequestMatcher.MatchOther.YES;
            }
        };
        PatternProcessor githubUserProcessor = new PatternProcessor("https://github\\.com/[\\w\\-]+"){

            @Override
            public RequestMatcher.MatchOther processPage(Page page) {
                log.info((Object)("Extracting from " + page.getUrl()));
                page.addTargetRequests(page.getHtml().links().regex("https://github\\.com/[\\w\\-]+/[\\w\\-]+").all());
                page.addTargetRequests(page.getHtml().links().regex("https://github\\.com/[\\w\\-]+").all());
                page.putField("username", (Object)page.getHtml().xpath("//span[@class='vcard-fullname']/text()").toString());
                return RequestMatcher.MatchOther.YES;
            }

            @Override
            public RequestMatcher.MatchOther processResult(ResultItems resultItems, Task task) {
                System.out.println("User name: " + resultItems.get("username"));
                return RequestMatcher.MatchOther.YES;
            }
        };
        CompositePageProcessor pageProcessor = new CompositePageProcessor(Site.me().setDomain("github.com").setRetryTimes(3));
        CompositePipeline pipeline = new CompositePipeline();
        pageProcessor.setSubPageProcessors(githubRepoProcessor, githubUserProcessor);
        pipeline.setSubPipeline(githubRepoProcessor, githubUserProcessor);
        Spider.create((PageProcessor)pageProcessor).addUrl(new String[]{"https://github.com/code4craft"}).thread(5).addPipeline((Pipeline)pipeline).runAsync();
    }
}

