/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.DuplicateRemovedScheduler;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;
import us.codecraft.webmagic.scheduler.component.DuplicateRemover;

public class RedisScheduler
extends DuplicateRemovedScheduler
implements MonitorableScheduler,
DuplicateRemover {
    private JedisPool pool;
    private static final String QUEUE_PREFIX = "queue_";
    private static final String SET_PREFIX = "set_";
    private static final String ITEM_PREFIX = "item_";

    public RedisScheduler(String host) {
        this(new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), host));
    }

    public RedisScheduler(JedisPool pool) {
        this.pool = pool;
        this.setDuplicateRemover(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDuplicateCheck(Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.del(new String[]{this.getSetKey(task)});
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicate(Request request, Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            boolean isDuplicate = jedis.sismember(this.getSetKey(task), request.getUrl());
            if (!isDuplicate) {
                jedis.sadd(this.getSetKey(task), request.getUrl());
            }
            boolean bl = isDuplicate;
            return bl;
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushWhenNoDuplicate(Request request, Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.rpush(this.getQueueKey(task), request.getUrl());
            if (request.getExtras() != null) {
                String field = DigestUtils.shaHex((String)request.getUrl());
                String value = JSON.toJSONString((Object)request);
                jedis.hset(ITEM_PREFIX + task.getUUID(), field, value);
            }
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Request poll(Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            Request request;
            String url = jedis.lpop(this.getQueueKey(task));
            if (url == null) {
                Request request2 = null;
                return request2;
            }
            String key = ITEM_PREFIX + task.getUUID();
            String field = DigestUtils.shaHex((String)url);
            byte[] bytes = jedis.hget(key.getBytes(), field.getBytes());
            if (bytes != null) {
                Request o;
                Request request3 = o = (Request)JSON.parseObject((String)new String(bytes), Request.class);
                return request3;
            }
            Request request4 = request = new Request(url);
            return request4;
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    protected String getSetKey(Task task) {
        return SET_PREFIX + task.getUUID();
    }

    protected String getQueueKey(Task task) {
        return QUEUE_PREFIX + task.getUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeftRequestsCount(Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            Long size = jedis.llen(this.getQueueKey(task));
            int n = size.intValue();
            return n;
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRequestsCount(Task task) {
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            Long size = jedis.scard(this.getQueueKey(task));
            int n = size.intValue();
            return n;
        }
        finally {
            this.pool.returnResource((Object)jedis);
        }
    }
}

