/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.pipeline;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.model.HasKey;
import us.codecraft.webmagic.pipeline.PageModelPipeline;
import us.codecraft.webmagic.utils.FilePersistentBase;

public class FilePageModelPipeline
extends FilePersistentBase
implements PageModelPipeline {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public FilePageModelPipeline() {
        this.setPath("/data/webmagic/");
    }

    public FilePageModelPipeline(String path) {
        this.setPath(path);
    }

    public void process(Object o, Task task) {
        String path = this.path + "/" + task.getUUID() + "/";
        try {
            String filename = o instanceof HasKey ? path + ((HasKey)o).key() + ".html" : path + DigestUtils.md5Hex((String)ToStringBuilder.reflectionToString((Object)o)) + ".html";
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.getFile(filename)));
            printWriter.write(ToStringBuilder.reflectionToString((Object)o));
            printWriter.close();
        }
        catch (IOException e) {
            this.logger.warn("write file error", (Throwable)e);
        }
    }
}

