/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.SpiderListener;
import us.codecraft.webmagic.SpiderScheduler;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.pipeline.CollectorPipeline;
import us.codecraft.webmagic.pipeline.ConsolePipeline;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.pipeline.ResultItemsCollectorPipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.scheduler.QueueScheduler;
import us.codecraft.webmagic.scheduler.Scheduler;
import us.codecraft.webmagic.thread.CountableThreadPool;
import us.codecraft.webmagic.utils.UrlUtils;
import us.codecraft.webmagic.utils.WMCollections;

public class Spider
implements Runnable,
Task {
    protected Downloader downloader;
    protected List<Pipeline> pipelines = new ArrayList<Pipeline>();
    protected PageProcessor pageProcessor;
    protected List<Request> startRequests;
    protected Site site;
    protected String uuid;
    protected SpiderScheduler scheduler;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected CountableThreadPool threadPool;
    protected ExecutorService executorService;
    protected int threadNum = 1;
    protected AtomicInteger stat = new AtomicInteger(0);
    protected volatile boolean exitWhenComplete = true;
    protected static final int STAT_INIT = 0;
    protected static final int STAT_RUNNING = 1;
    protected static final int STAT_STOPPED = 2;
    protected boolean spawnUrl = true;
    protected boolean destroyWhenExit = true;
    private List<SpiderListener> spiderListeners;
    private final AtomicLong pageCount = new AtomicLong(0L);
    private Date startTime;
    private long emptySleepTime = 30000L;

    public static Spider create(PageProcessor pageProcessor) {
        return new Spider(pageProcessor);
    }

    public Spider(PageProcessor pageProcessor) {
        this.pageProcessor = pageProcessor;
        this.site = pageProcessor.getSite();
        this.scheduler = new SpiderScheduler(new QueueScheduler());
    }

    public Spider startUrls(List<String> startUrls) {
        this.checkIfRunning();
        this.startRequests = UrlUtils.convertToRequests(startUrls);
        return this;
    }

    public Spider startRequest(List<Request> startRequests) {
        this.checkIfRunning();
        this.startRequests = startRequests;
        return this;
    }

    public Spider setUUID(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Deprecated
    public Spider scheduler(Scheduler scheduler) {
        return this.setScheduler(scheduler);
    }

    public Spider setScheduler(Scheduler updateScheduler) {
        this.checkIfRunning();
        Scheduler oldScheduler = this.scheduler.getScheduler();
        this.scheduler.setScheduler(updateScheduler);
        if (oldScheduler != null) {
            Request request;
            while ((request = oldScheduler.poll(this)) != null) {
                this.scheduler.push(request, this);
            }
        }
        return this;
    }

    @Deprecated
    public Spider pipeline(Pipeline pipeline) {
        return this.addPipeline(pipeline);
    }

    public Spider addPipeline(Pipeline pipeline) {
        this.checkIfRunning();
        this.pipelines.add(pipeline);
        return this;
    }

    public Spider setPipelines(List<Pipeline> pipelines) {
        this.checkIfRunning();
        this.pipelines = pipelines;
        return this;
    }

    public Spider clearPipeline() {
        this.pipelines = new ArrayList<Pipeline>();
        return this;
    }

    @Deprecated
    public Spider downloader(Downloader downloader) {
        return this.setDownloader(downloader);
    }

    public Spider setDownloader(Downloader downloader) {
        this.checkIfRunning();
        this.downloader = downloader;
        return this;
    }

    protected void initComponent() {
        if (this.downloader == null) {
            this.downloader = new HttpClientDownloader();
        }
        if (this.pipelines.isEmpty()) {
            this.pipelines.add(new ConsolePipeline());
        }
        this.downloader.setThread(this.threadNum);
        if (this.threadPool == null || this.threadPool.isShutdown()) {
            this.threadPool = this.executorService != null && !this.executorService.isShutdown() ? new CountableThreadPool(this.threadNum, this.executorService) : new CountableThreadPool(this.threadNum);
        }
        if (this.startRequests != null) {
            for (Request request : this.startRequests) {
                this.addRequest(request);
            }
            this.startRequests.clear();
        }
        this.startTime = new Date();
    }

    @Override
    public void run() {
        this.checkRunningStat();
        this.initComponent();
        this.logger.info("Spider {} started!", (Object)this.getUUID());
        while (!Thread.currentThread().isInterrupted() && this.stat.get() == 1) {
            Request poll = this.scheduler.poll(this);
            if (poll == null) {
                if (this.threadPool.getThreadAlive() == 0) {
                    poll = this.scheduler.poll(this);
                    if (poll == null) {
                        if (this.exitWhenComplete) break;
                        try {
                            Thread.sleep(this.emptySleepTime);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                } else {
                    if (!this.scheduler.waitNewUrl(this.threadPool, this.emptySleepTime)) continue;
                    break;
                }
            }
            final Request request = poll;
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Spider.this.processRequest(request);
                        Spider.this.onSuccess(request);
                    }
                    catch (Exception e) {
                        Spider.this.onError(request, e);
                        Spider.this.logger.error("process request " + request + " error", (Throwable)e);
                    }
                    finally {
                        Spider.this.pageCount.incrementAndGet();
                        Spider.this.scheduler.signalNewUrl();
                    }
                }
            });
        }
        this.stat.set(2);
        if (this.destroyWhenExit) {
            this.close();
        }
        this.logger.info("Spider {} closed! {} pages downloaded.", (Object)this.getUUID(), (Object)this.pageCount.get());
    }

    @Deprecated
    protected void onError(Request request) {
    }

    protected void onError(Request request, Exception e) {
        this.onError(request);
        if (CollectionUtils.isNotEmpty(this.spiderListeners)) {
            for (SpiderListener spiderListener : this.spiderListeners) {
                spiderListener.onError(request, e);
            }
        }
    }

    protected void onSuccess(Request request) {
        if (CollectionUtils.isNotEmpty(this.spiderListeners)) {
            for (SpiderListener spiderListener : this.spiderListeners) {
                spiderListener.onSuccess(request);
            }
        }
    }

    private void checkRunningStat() {
        int statNow;
        do {
            if ((statNow = this.stat.get()) != 1) continue;
            throw new IllegalStateException("Spider is already running!");
        } while (!this.stat.compareAndSet(statNow, 1));
    }

    public void close() {
        this.destroyEach(this.downloader);
        this.destroyEach(this.pageProcessor);
        this.destroyEach(this.scheduler);
        for (Pipeline pipeline : this.pipelines) {
            this.destroyEach(pipeline);
        }
        this.threadPool.shutdown();
    }

    private void destroyEach(Object object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void test(String ... urls) {
        this.initComponent();
        if (urls.length > 0) {
            for (String url : urls) {
                this.processRequest(new Request(url));
            }
        }
    }

    private void processRequest(Request request) {
        Page page = null != request.getDownloader() ? request.getDownloader().download(request, this) : this.downloader.download(request, this);
        if (page.isDownloadSuccess()) {
            this.onDownloadSuccess(request, page);
        } else {
            this.onDownloaderFail(request);
        }
    }

    private void onDownloadSuccess(Request request, Page page) {
        if (this.site.getAcceptStatCode().contains(page.getStatusCode())) {
            this.pageProcessor.process(page);
            this.extractAndAddRequests(page, this.spawnUrl);
            if (!page.getResultItems().isSkip()) {
                for (Pipeline pipeline : this.pipelines) {
                    pipeline.process(page.getResultItems(), this);
                }
            }
        } else {
            this.logger.info("page status code error, page {} , code: {}", (Object)request.getUrl(), (Object)page.getStatusCode());
        }
        this.sleep(this.site.getSleepTime());
    }

    private void onDownloaderFail(Request request) {
        if (this.site.getCycleRetryTimes() == 0) {
            this.sleep(this.site.getSleepTime());
        } else {
            this.doCycleRetry(request);
        }
    }

    private void doCycleRetry(Request request) {
        Object cycleTriedTimesObject = request.getExtra("_cycle_tried_times");
        if (cycleTriedTimesObject == null) {
            this.addRequest(((Request)SerializationUtils.clone((Serializable)request)).setPriority(0L).putExtra("_cycle_tried_times", 1));
        } else {
            int cycleTriedTimes = (Integer)cycleTriedTimesObject;
            if (++cycleTriedTimes < this.site.getCycleRetryTimes()) {
                this.addRequest(((Request)SerializationUtils.clone((Serializable)request)).setPriority(0L).putExtra("_cycle_tried_times", cycleTriedTimes));
            }
        }
        this.sleep(this.site.getRetrySleepTime());
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted when sleep", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    protected void extractAndAddRequests(Page page, boolean spawnUrl) {
        if (spawnUrl && CollectionUtils.isNotEmpty(page.getTargetRequests())) {
            for (Request request : page.getTargetRequests()) {
                this.addRequest(request);
            }
        }
    }

    private void addRequest(Request request) {
        if (this.site.getDomain() == null && request != null && request.getUrl() != null) {
            this.site.setDomain(UrlUtils.getDomain(request.getUrl()));
        }
        this.scheduler.push(request, this);
    }

    protected void checkIfRunning() {
        if (this.stat.get() == 1) {
            throw new IllegalStateException("Spider is already running!");
        }
    }

    public void runAsync() {
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        thread.start();
    }

    public Spider addUrl(String ... urls) {
        for (String url : urls) {
            this.addRequest(new Request(url));
        }
        this.scheduler.signalNewUrl();
        return this;
    }

    public <T> List<T> getAll(Collection<String> urls) {
        this.destroyWhenExit = false;
        this.spawnUrl = false;
        if (this.startRequests != null) {
            this.startRequests.clear();
        }
        for (Request request : UrlUtils.convertToRequests(urls)) {
            this.addRequest(request);
        }
        CollectorPipeline collectorPipeline = this.getCollectorPipeline();
        this.pipelines.add(collectorPipeline);
        this.run();
        this.spawnUrl = true;
        this.destroyWhenExit = true;
        return collectorPipeline.getCollected();
    }

    protected CollectorPipeline getCollectorPipeline() {
        return new ResultItemsCollectorPipeline();
    }

    public <T> T get(String url) {
        List<String> urls = WMCollections.newArrayList(url);
        List<T> resultItemses = this.getAll(urls);
        if (resultItemses != null && resultItemses.size() > 0) {
            return resultItemses.get(0);
        }
        return null;
    }

    public Spider addRequest(Request ... requests) {
        for (Request request : requests) {
            this.addRequest(request);
        }
        this.scheduler.signalNewUrl();
        return this;
    }

    public void start() {
        this.runAsync();
    }

    public void stop() {
        if (this.stat.compareAndSet(1, 2)) {
            this.logger.info("Spider " + this.getUUID() + " stop success!");
        } else {
            this.logger.info("Spider " + this.getUUID() + " stop fail!");
        }
    }

    public void stopWhenComplete() {
        this.exitWhenComplete = true;
    }

    public Spider thread(int threadNum) {
        this.checkIfRunning();
        this.threadNum = threadNum;
        if (threadNum <= 0) {
            throw new IllegalArgumentException("threadNum should be more than one!");
        }
        return this;
    }

    public Spider thread(ExecutorService executorService, int threadNum) {
        this.checkIfRunning();
        this.threadNum = threadNum;
        if (threadNum <= 0) {
            throw new IllegalArgumentException("threadNum should be more than one!");
        }
        this.executorService = executorService;
        return this;
    }

    public boolean isExitWhenComplete() {
        return this.exitWhenComplete;
    }

    public Spider setExitWhenComplete(boolean exitWhenComplete) {
        this.exitWhenComplete = exitWhenComplete;
        return this;
    }

    public boolean isSpawnUrl() {
        return this.spawnUrl;
    }

    public long getPageCount() {
        return this.pageCount.get();
    }

    public Status getStatus() {
        return Status.fromValue(this.stat.get());
    }

    public int getThreadAlive() {
        if (this.threadPool == null) {
            return 0;
        }
        return this.threadPool.getThreadAlive();
    }

    public Spider setSpawnUrl(boolean spawnUrl) {
        this.spawnUrl = spawnUrl;
        return this;
    }

    @Override
    public String getUUID() {
        if (this.uuid != null) {
            return this.uuid;
        }
        if (this.site != null) {
            return this.site.getDomain();
        }
        this.uuid = UUID.randomUUID().toString();
        return this.uuid;
    }

    public Spider setExecutorService(ExecutorService executorService) {
        this.checkIfRunning();
        this.executorService = executorService;
        return this;
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    public List<SpiderListener> getSpiderListeners() {
        return this.spiderListeners;
    }

    public Spider setSpiderListeners(List<SpiderListener> spiderListeners) {
        this.spiderListeners = spiderListeners;
        return this;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    public Spider setEmptySleepTime(long emptySleepTime) {
        if (emptySleepTime <= 0L) {
            throw new IllegalArgumentException("emptySleepTime should be more than zero!");
        }
        this.emptySleepTime = emptySleepTime;
        return this;
    }

    public static enum Status {
        Init(0),
        Running(1),
        Stopped(2);

        private int value;

        private Status(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        public static Status fromValue(int value) {
            for (Status status : Status.values()) {
                if (status.getValue() != value) continue;
                return status;
            }
            return Init;
        }
    }
}

