/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Json;
import us.codecraft.webmagic.selector.Selectable;
import us.codecraft.webmagic.utils.UrlUtils;

public class Page {
    private Request request;
    private ResultItems resultItems = new ResultItems();
    private Html html;
    private Json json;
    private String rawText;
    private Selectable url;
    private Map<String, List<String>> headers;
    private int statusCode = 200;
    private boolean downloadSuccess = true;
    private byte[] bytes;
    private List<Request> targetRequests = new ArrayList<Request>();
    private String charset;

    @Deprecated
    public static Page fail() {
        return Page.fail(null);
    }

    public static Page fail(Request request) {
        Page page = new Page();
        page.setRequest(request);
        page.setDownloadSuccess(false);
        return page;
    }

    public Page setSkip(boolean skip) {
        this.resultItems.setSkip(skip);
        return this;
    }

    public void putField(String key, Object field) {
        this.resultItems.put(key, field);
    }

    public Html getHtml() {
        if (this.html == null) {
            this.html = new Html(this.rawText, this.request.getUrl());
        }
        return this.html;
    }

    public Json getJson() {
        if (this.json == null) {
            this.json = new Json(this.rawText);
        }
        return this.json;
    }

    @Deprecated
    public void setHtml(Html html) {
        this.html = html;
    }

    public List<Request> getTargetRequests() {
        return this.targetRequests;
    }

    public void addTargetRequests(Iterable<String> requests) {
        this.addTargetRequests(requests, 0L);
    }

    public void addTargetRequests(Iterable<String> requests, long priority) {
        if (requests == null) {
            return;
        }
        for (String req : requests) {
            this.addRequestIfValid(req, priority);
        }
    }

    private void addRequestIfValid(String url, long priority) {
        if (StringUtils.isBlank((CharSequence)url) || url.equals("#") || url.startsWith("javascript:")) {
            return;
        }
        String canonicalizedUrl = UrlUtils.canonicalizeUrl(url, this.url.toString());
        Request req = new Request(canonicalizedUrl);
        if (priority > 0L) {
            req.setPriority(priority);
        }
        this.targetRequests.add(req);
    }

    public void addTargetRequest(String requestString) {
        if (StringUtils.isBlank((CharSequence)requestString) || requestString.equals("#")) {
            return;
        }
        requestString = UrlUtils.canonicalizeUrl(requestString, this.url.toString());
        this.targetRequests.add(new Request(requestString));
    }

    public void addTargetRequest(Request request) {
        this.targetRequests.add(request);
    }

    public Selectable getUrl() {
        return this.url;
    }

    public void setUrl(Selectable url) {
        this.url = url;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
        this.resultItems.setRequest(request);
    }

    public ResultItems getResultItems() {
        return this.resultItems;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getRawText() {
        return this.rawText;
    }

    public Page setRawText(String rawText) {
        this.rawText = rawText;
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public boolean isDownloadSuccess() {
        return this.downloadSuccess;
    }

    public void setDownloadSuccess(boolean downloadSuccess) {
        this.downloadSuccess = downloadSuccess;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toString() {
        return "Page{request=" + this.request + ", resultItems=" + this.resultItems + ", html=" + this.html + ", json=" + this.json + ", rawText='" + this.rawText + "', url=" + this.url + ", headers=" + this.headers + ", statusCode=" + this.statusCode + ", downloadSuccess=" + this.downloadSuccess + ", targetRequests=" + this.targetRequests + ", charset='" + this.charset + "', bytes=" + Arrays.toString(this.bytes) + "}";
    }
}

